#---------------------------------------------------------------
# File Output
#----------------------------------------------------------------

#
# window_File and make_File

proc Window_File {} {
    global file w l c pr

    set wn $w(main).output
    if [winfo exists $wn] {
        $w(outcontrolbutton) configure -text " " \
            -bg $l(c7) -activebackground $l(c7)
        destroy $wn
        return
    }
    $w(outcontrolbutton) configure -text " " \
        -bg $l(c8) -activebackground $l(c8)

    frame $wn -bd 5 -relief flat
    pack $wn -side right -expand yes -fill both

    #
    # Option control
    #
    frame $wn.op -bd 1 -relief groove
    frame $wn.op.1 -bd 0
    frame $wn.op.2 -bd 0
    frame $wn.op.3 -bd 0
    frame $wn.op.4 -bd 0
    frame $wn.op.5 -bd 0
    pack $wn.op.1 $wn.op.2 $wn.op.3 $wn.op.4 $wn.op.5 -side top -fill x
    checkbutton $wn.op.1.0 -text "-" -variable c(autoview) \
                -anchor w -width 0 -pady 0
    checkbutton $wn.op.2.0 -text "-" -variable c(autoconvert) \
                -anchor w -width 0 -pady 0
    checkbutton $wn.op.3.0 -text "-" -variable c(autoprint) \
                -anchor w -width 0 -pady 0
    label $wn.op.1.1 -text "View with"  -anchor w -width 10 -pady 0
    label $wn.op.2.1 -text "Convert to" -anchor w -width 10 -pady 0
    label $wn.op.3.1 -text "Print to"   -anchor w -width 10 -pady 0
    label $wn.op.5.1 -text "Automatic Output Processing" -anchor w -pady 0
    menubutton $wn.op.1.2 -menu $wn.op.1.2.m -text $c(ImageEditor) \
               -width 11 -fg $l(c1) -relief ridge -pady 0
    menubutton $wn.op.2.2 -menu $wn.op.2.2.m -text $file(type) \
               -width 11 -fg $l(c1) -relief ridge -pady 0
    menubutton $wn.op.3.2 -menu $wn.op.3.2.m -text $pr(printer) \
               -width 11 -fg $l(c1) -relief ridge -pady 0
    label $wn.op.4.0 -text "|       Zoom" -width 10 -padx 0 -pady 0 -anchor e
    menubutton $wn.op.4.1 -text X -menu $wn.op.4.1.m \
               -width 2 -pady 2 -anchor e -bd 1 -relief ridge
    menu $wn.op.4.1.m -tearoff false
    $wn.op.4.1.m add command -label X -command "set pr(xoffset) X"
    $wn.op.4.1.m add command -label C -command "set pr(xoffset) C"
    $wn.op.4.1.m add command -label L -command "set pr(xoffset) L"
    $wn.op.4.1.m add command -label R -command "set pr(xoffset) R"
    menubutton $wn.op.4.2 -text Y -menu $wn.op.4.2.m \
               -width 2 -pady 2 -anchor e -bd 1 -relief ridge
    menu $wn.op.4.2.m -tearoff false
    $wn.op.4.2.m add command -label Y -command "set pr(yoffset) Y"
    $wn.op.4.2.m add command -label C -command "set pr(yoffset) C"
    $wn.op.4.2.m add command -label T -command "set pr(yoffset) T"
    $wn.op.4.2.m add command -label B -command "set pr(yoffset) B"
    entry $wn.op.4.a -textvariable pr(zoom)    \
          -width 3 -justify left -fg $l(c1) -font $l(f1)
    entry $wn.op.4.b -textvariable pr(xoffset) \
          -width 3 -justify left -fg $l(c1) -font $l(f1)
    entry $wn.op.4.c -textvariable pr(yoffset) \
          -width 3 -justify left -fg $l(c1) -font $l(f1)
    pack $wn.op.1.0 $wn.op.1.1 $wn.op.1.2 -side left
    pack $wn.op.2.0 $wn.op.2.1 $wn.op.2.2 -side left
    pack $wn.op.3.0 $wn.op.3.1 $wn.op.3.2 -side left
    pack $wn.op.4.0 $wn.op.4.a $wn.op.4.1 $wn.op.4.b $wn.op.4.2 $wn.op.4.c \
         -side left
    pack $wn.op.5.1 -side left

    set w(ieditor) $wn.op.1.2
    set w(filetype) $wn.op.2.2
    set w(printer) $wn.op.3.2

    menu $wn.op.1.2.m -tearoff false
    foreach i $c(ImageEditorList) { set iename [lindex $i 0]
        $wn.op.1.2.m add command -label $iename -command "
            $wn.op.1.2 configure -text $iename
            set c(ImageEditor) $iename
        "
    }

    menu $wn.op.2.2.m -tearoff false
    foreach i $file(typeList) { set type [lindex $i 0]
        $wn.op.2.2.m add command -label $type -command "setFiletype $type"
    }

    menu $wn.op.3.2.m -tearoff false
    foreach i $pr(printerList) { set printer [lindex $i 0]
        $wn.op.3.2.m add command -label $printer -command "setPrinter $printer"
    }

    #
    # File browser

    # 1st line
    frame $wn.dir -bd 1 -relief groove
    frame $wn.dir.l
    label $wn.dir.l.l -text Directory -anchor w -pady 0
    button $wn.dir.l.0 -text mkdir -width 4 -pady 0 -relief ridge -bg skyblue \
    -command {
        if ![file exists $file(dir)] {
            exec mkdir $file(dir)
            cd $file(dir)
            update_dir
        }
    }
    pack $wn.dir.l.l -side left -fill x
    pack $wn.dir.l.0 -side right -fill x
    # 2nd line
    entry $wn.dir.e -textvariable file(dir) \
          -relief sunken -font $l(f1) -fg $l(c1)
    bind $wn.dir.e <KeyPress-Return> update_dir
    # 3rd line
    frame $wn.dir.x
    label $wn.dir.x.l -text Files -anchor w -pady 0
    button $wn.dir.x.0 -text update -width 4 -pady 0 -relief ridge \
           -bg skyblue -command update_dir
    checkbutton $wn.dir.x.1 -text "Image files only" \
                -variable file(imageonly) -anchor w -pady 0
    pack $wn.dir.x.l  -side left -fill x
    pack $wn.dir.x.0 $wn.dir.x.1 -side right -fill x
    # Listbox
    frame $wn.dir.f
    set w(dirlist) $wn.dir.f.b
    listbox $wn.dir.f.b -width 24 -height 7 -relief sunken -font $l(f1) \
            -yscroll "$wn.dir.f.s set"
    bind $wn.dir.f.b <Double-Button-1> file_open_file
    scrollbar $wn.dir.f.s -command "$wn.dir.f.b yview"
    pack $wn.dir.f.b -side left  -fill both -expand yes
    pack $wn.dir.f.s -side right -fill y
    frame $wn.dir.b
    button $wn.dir.b.1 -text View    -width 4 -pady 0 -relief ridge \
           -bg #afeeee -command file_open_file
    button $wn.dir.b.2 -text Convert -width 4 -pady 0 -relief ridge \
           -bg #afeeee -command file_convert
    button $wn.dir.b.3 -text Rename  -width 4 -pady 0 -relief ridge \
           -bg #afeeee -command file_rename_file
    button $wn.dir.b.4 -text Remove  -width 4 -pady 0 -relief ridge \
           -bg #afeeee -command file_remove_file
    pack $wn.dir.b.1 $wn.dir.b.2 $wn.dir.b.3 $wn.dir.b.4 \
         -side left -fill x -expand yes
    pack $wn.dir.l $wn.dir.e $wn.dir.x $wn.dir.f $wn.dir.b -side top -fill x

    pack $wn.dir $wn.op -side top -expand yes -fill x

    # get file list
    update_dir
}

#
# Subroutines

proc setFiletype { type } {
    global file w
    set file(type) $type
    $w(filetype) configure -text $type
    set file(surfix) $file(surfix_$type)
}

proc setPrinter { printer } {
    global pr w
    set pr(printer) $printer
    $w(printer) configure -text $printer
}

proc update_dir {} { global file w
    $w(dirlist) delete 0 end
    set filelist [exec ls -a $file(dir)]
    foreach i $filelist {
        if {[file isdirectory $file(dir)/$i] && $i!="."} {
            $w(dirlist) insert end [format " %9s  %-17s " "Directory" $i]
        }
    }
    foreach i $filelist {
        if { [file isfile $file(dir)/$i] && \
             ([regexp -nocase $file(surfixList) $i] || !$file(imageonly)) } {
            set size [expr [file size $file(dir)/$i] / 1024.0]
            $w(dirlist) insert end [format " %6.0f  %-20s " $size $i]
        }
    }
}

proc check_outfile { filename } {
    if [file exists $filename] {
        update_dir
    } else {
        after 1000 check_outfile $filename
    }
}

proc file_open_file {} {
    global c file w
    if {[$w(dirlist) curselection] != {}} {
        set f [lindex [selection get] 1]
        if [file isdirectory $file(dir)/$f] {
            set xx [expr [string last / $file(dir)]-1]
            if {$f==".."} {
                if {$xx < 0} { set file(dir) "/"
                } else { set file(dir) [string range $file(dir) 0 $xx] }
            } else {
                if {$file(dir)=="/"} { set file(dir) "/$f"
                } else { set file(dir) "$file(dir)/$f" }
            }
            update_dir
        } else {
            set viewer $c($c(ImageEditor)command)
            exec sh -c "$viewer $file(dir)/$f" &
        }
    }
}

proc file_convert {} {
    global c file w
    if {[$w(dirlist) curselection] != {}} {
        set f [lindex [selection get] 1]
        if [file isfile $file(dir)/$f] {
            # Output filename
            set p [string last . $f]
            if {$p < 0} {
                set prefix $f
            } else {
                set prefix [string range $f 0 [expr $p - 1]]
            }
            set outfile $prefix.$file(surfix)
            # Run ImageMagic's convert
            exec sh -c "convert $file(dir)/$f $file(dir)/$outfile"
            # Update file list
            update_dir
        }
    }
}

proc file_remove_file {} {
    global file w
    if {[$w(dirlist) curselection] != {}} {
        set f [lindex [selection get] 1]
        if [file isdirectory $f] {
        } else {
            after idle {.dialog.msg configure -wraplength 4i}
            set i [tk_dialog .dialog "TkFax File Remove" \
            "Remove a file \"$f\"?" {} 0 {OK} {Cancel}]
            if {$i==0} {
                exec sh -c "rm -f $file(dir)/$f"
                update_dir
            }
        }
    }
}

proc file_rename_file {} {
    global c file l w
    if {[$w(dirlist) curselection] != {}} {
        set c(sf) [lindex [selection get] 1]
        set c(nf) ""
        set wn .fr
        set w(filerename) $wn
        toplevel $wn
        grab set $wn
        wm title $wn "TkScan: File Rename"
        wm transient $wn [winfo toplevel [winfo parent $wn]]
        set wn $wn.fr
        frame $wn -bd 5
        pack $wn -side top
        frame $wn.0 -bd 4
        frame $wn.1
        frame $wn.2
        frame $wn.3 -bd 4
        pack $wn.0 $wn.1 $wn.2 $wn.3 -side top -fill x
        label $wn.0.0 -text "TkScan: File Rename" -padx 5 -pady 2 -relief ridge
        pack $wn.0.0 -side left -fill x -expand yes
        label $wn.1.0 -text "File Name:" -width 15 -anchor e
        entry $wn.1.1 -textvariable c(sf) -width 20 -fg $l(c1)
        pack $wn.1.0 $wn.1.1 -side left
        label $wn.2.0 -text "New File Name:" -width 15 -anchor e
        entry $wn.2.1 -textvariable c(nf) -width 20 -fg $l(c1)
        pack $wn.2.0 $wn.2.1 -side left
        button $wn.3.1 -text OK -width 8 -command {
            if {$c(nf)!={}} {
                exec mv -f $file(dir)/$c(sf) $file(dir)/$c(nf)
                destroy $w(filerename)
                update_dir
            }
        }
        button $wn.3.2 -text Cancel -width 8 -command { destroy $w(filerename) }
        pack $wn.3.1 $wn.3.2 -side left -expand yes
        bind $wn.2.1 <Return> {
            if {$c(nf)!={}} {
                exec mv -f $file(dir)/$c(sf) $file(dir)/$c(nf)
                destroy $w(filerename)
                update_dir
            }
        }
        focus $wn.2.1
    }
}

