#----------------------------------------------------------------
# Procedures for configurations
#----------------------------------------------------------------

proc savesettings {} { global s c
    set file [open "$c(userconf)" w]
    puts $file "# tkscan user configuration"
    foreach i $s(saveList) { puts $file "set s($i)\t\"$s($i)\"" }
    foreach i $c(saveList) { puts $file "set c($i)\t\"$c($i)\"" }
    puts $file "\n# end of tkscan user configuration"
    close $file
}

proc setcur { type } { global s w
    foreach i $s(settingList) {set s($i) $s($type$i)}
    setmode $s(mode)
}

proc savecur { type } { global s
    foreach i $s(settingList) {set s($type$i) $s($i)}
}

proc setmode { mode } { global s c w
    set s(mode) $mode
    if $s(premodecurrent) { set s(premode) $mode }
    $w(mo).m.mode configure -text $mode
    if [winfo exists $w(main).option] { option_select }
    showsize 0
}

proc option_select {} { global s w
    foreach i $s(modedepoptionList) { $w(main).option.$i.l configure -fg gray }
    foreach i $s($s(mode)option) { $w(main).option.$i.l configure -fg black }
}

proc setquickmode { mode } { global s c
    setcur Default
    foreach k $c(qmode$mode) {
        set l [string first = $k]
        set arg [string range $k 0 [expr [string first = $k]-1]]
        set val [string range $k [expr [string first = $k]+1] end]
        set s($arg) $val
    }
    setmode $s(mode)
}

proc setquickpaper { paper } { global s c
    for {set j 0} {$j<4} {incr j} { set z$j [format "%0.0f" \
        [expr [lindex $c(qpaper$paper) $j]*$s(preresolution)+$s(o)]] }
    settop $z0 $z1 ; setbottom $z2 $z3
}

proc setcopymachine_gray {} {
    global c w
    setquickmode GrayCopy
    setquickpaper A4
    set c(autoconvert) 0
    set c(autodelete) 1
    set c(autofax) 0
    set c(autoprint) 1
    set c(autoview) 0
    $w(main).menu.l configure -text "TkScan $c(version): Gray Copy"
}

proc setcopymachine_color {} {
    global c w
    setquickmode ColorCopy
    setquickpaper A4
    set c(autoconvert) 0
    set c(autodelete) 1
    set c(autofax) 0
    set c(autoprint) 1
    set c(autoview) 0
    $w(main).menu.l configure -text "TkScan $c(version): Color Copy"
}

proc setfaxmachine {} {
    global c w
    setquickmode Fax
    setquickpaper A4
    set c(autoconvert) 0
    set c(autodelete) 1
    set c(autofax) 1
    set c(autoprint) 0
    set c(autoview) 0
    $w(main).menu.l configure -text "TkScan $c(version): Fax Scan"
}

proc setscannerdefault {} {
    global c w
    setquickmode Default
    setquickpaper A4
    set c(autoconvert) 0
    set c(autodelete) 0
    set c(autofax) 0
    set c(autoprint) 0
    set c(autoview) 0
    $w(main).menu.l configure -text "TkScan $c(version)"
}

proc setpremode { mode } { global s w
    $w(premodebutton) configure -text $mode
    if { $mode == "Current" } {
        set s(premodecurrent) 1
        set s(premode) $s(mode)
    } else {
        set s(premodecurrent) 0
        set s(premode) $mode
    }
}

proc setpreresolution { resolution } { global s w
    set s(preresolution) $resolution
    Preview_Canvas
    deleteallrect
    image create photo preview -data {}
}

proc Preview_Canvas {} { global s w
    set s(o) 6
    set s(prebd) 2
    set s(scanpwidth) [format "%0.0f" [expr $s(scanwidth) *$s(preresolution)]]
    set s(scanpheight) [format "%0.0f" [expr $s(scanheight)*$s(preresolution)]]
    set s(maxpwidth) [expr $s(scanpwidth) +$s(o)]
    set s(maxpheight) [expr $s(scanpheight)+$s(o)]
    set s(prewidth) [expr $s(scanpwidth) +2*($s(o)-$s(prebd)-1)]
    set s(preheight) [expr $s(scanpheight)+2*($s(o)-$s(prebd)-1)]
    $w(prev) configure -width $s(prewidth) -height $s(preheight) -bd $s(prebd)
}

proc setresolution { resolution } { global s
    set s(resolution) $resolution
    showsize 0
}

proc setunit { unit } { global s w
    set s(unit) $unit
    $w(sz).rs.unit configure -text "$unit^2"
    showsize 0
}

proc showsize { i } { global s w
    set txd [format "$s(f$s(unit))" [pixelto $s(unit) [expr $s(tx$i)-$s(o)]]]
    set tyd [format "$s(f$s(unit))" [pixelto $s(unit) [expr $s(ty$i)-$s(o)]]]
    set bxd [format "$s(f$s(unit))" [pixelto $s(unit) [expr $s(bx$i)-$s(o)]]]
    set byd [format "$s(f$s(unit))" [pixelto $s(unit) [expr $s(by$i)-$s(o)]]]
    set wd [pixelto $s(unit) [expr $s(bx$i)-$s(tx$i)]]
    set ht [pixelto $s(unit) [expr $s(by$i)-$s(ty$i)]]
    set s(sizeReal) [format "$s(f$s(unit)) x $s(f$s(unit))" $wd $ht]
    set pwd [expr [pixelto inch [expr $s(bx$i)-$s(tx$i)]] * $s(resolution).0]
    set pht [expr [pixelto inch [expr $s(by$i)-$s(ty$i)]] * $s(resolution).0]
    set dsizefactor $s($s(mode)dsizefactor)
    set dsize [expr $pwd * $pht * $dsizefactor / 8192.0]
    set s(sizeScreen)	[format "%0.0f x %0.0f" $pwd $pht]
    set s(sizeData)	[format "%0.1f" $dsize]
    $w(ft) itemconfigure ul -text "($txd, $tyd)"
    $w(ft) itemconfigure lr -text "($bxd, $byd)"
    $w(sz).rs.size configure -text "$s(sizeReal)"
    $w(sz).ss.size configure -text "$s(sizeScreen)"
    $w(sz).ds.size configure -text "$s(sizeData)"
}

#----------------------------------------------------------------
# Procedures for Scanning Area Selection
#----------------------------------------------------------------

proc settop { xp yp } { global s w l
    if { $xp < $s(o) } { set xp $s(o) }
    if { $yp < $s(o) } { set yp $s(o) }
    if { $xp > $s(maxpwidth) } { set xp $s(maxpwidth) }
    if { $yp > $s(maxpheight) } { set yp $s(maxpheight) }
    set s(tx0) $xp
    set s(ty0) $yp
    set s(bx0) $s(tx0)
    set s(by0) $s(ty0)
    $w(prev) delete $s(rect0)
    set s(rect0) [$w(prev) create rectangle $s(tx0) $s(ty0) $s(bx0) $s(by0) \
                  -width 1 -outline $l(c2)]
    showsize 0
}

proc setbottom { xp yp } { global s w
    if { $xp < $s(o) } { set xp $s(o) }
    if { $yp < $s(o) } { set yp $s(o) }
    if { $xp > $s(maxpwidth) } { set xp $s(maxpwidth) }
    if { $yp > $s(maxpheight) } { set yp $s(maxpheight) }
    if { $xp > $s(tx0) } { set s(bx0) $xp } else { set s(tx0) $xp }
    if { $yp > $s(ty0) } { set s(by0) $yp } else { set s(ty0) $yp }
    $w(prev) coords $s(rect0) $s(tx0) $s(ty0) $s(bx0) $s(by0)
    showsize 0
}

proc finetune { arg } { global s w
    if $s(xx) { return }
    switch $arg {
        tx- {if {$s(tx0) <= $s(o)} {return}}
        tx+ {if {$s(tx0) >= $s(bx0)} {return}}
        ty- {if {$s(ty0) <= $s(o)} {return}}
        ty+ {if {$s(ty0) >= $s(by0)} {return}}
        bx- {if {$s(bx0) <= $s(tx0)} {return}}
        bx+ {if {$s(bx0) >= $s(maxpwidth)} {return}}
        by- {if {$s(by0) <= $s(ty0)} {return}}
        by+ {if {$s(by0) >= $s(maxpheight)} {return}}
    }
    incr s([string range $arg 0 1]0) [string index $arg 2]1
    $w(prev) coords $s(rect0) $s(tx0) $s(ty0) $s(bx0) $s(by0)
    showsize 0
    after 200 finetune $arg
}

proc registrect { xp yp } { global s w l
    if [isinside $xp $yp $s(tx0) $s(ty0) $s(bx0) $s(by0)] {
        incr s(nrect) 1
        set s(tx$s(nrect)) $s(tx0)
        set s(ty$s(nrect)) $s(ty0)
        set s(bx$s(nrect)) $s(bx0)
        set s(by$s(nrect)) $s(by0)
        $w(prev) coords $s(rect0) 0 0 0 0
        set s(rect$s(nrect)) [$w(prev) create rectangle \
            $s(tx$s(nrect)) $s(ty$s(nrect)) $s(bx$s(nrect)) $s(by$s(nrect)) \
            -width 1 -outline $l(c3)]
        set s(num$s(nrect)) [$w(prev) create text \
                    [expr ( $s(tx$s(nrect)) + $s(bx$s(nrect))) / 2] \
                    [expr ( $s(ty$s(nrect)) + $s(by$s(nrect))) / 2] \
                    -text $s(nrect) -fill $l(c3)]
        stat_text "Registered Regions: $s(nrect)"
    }

}

proc deleterect { xp yp } { global s w l
    for {set i 1} {$i <= $s(nrect)} {incr i} {
        if [isinside $xp $yp $s(tx$i) $s(ty$i) $s(bx$i) $s(by$i)] {
            $w(prev) delete $s(rect$i)
            $w(prev) delete $s(num$i)
            set j $i
            while { $j < $s(nrect) } {
                set k [expr $j + 1]
                set s(tx$j) $s(tx$k)
                set s(ty$j) $s(ty$k)
                set s(bx$j) $s(bx$k)
                set s(by$j) $s(by$k)
                set s(rect$j) $s(rect$k)
                $w(prev) delete $s(num$k)
                set s(num$j) [$w(prev) create text \
                    [expr ( $s(tx$j) + $s(bx$j)) / 2] \
                    [expr ( $s(ty$j) + $s(by$j)) / 2] \
                    -text $j -fill $l(c3)]
                incr j 1
            }
            incr s(nrect) -1
            stat_text "Registered Regions: $s(nrect)"
            break
        }
    }
}

proc deleteallrect {} { global s w l
    for {set i 1} {$i <= $s(nrect)} {incr i} {
        $w(prev) delete $s(rect$i)
        $w(prev) delete $s(num$i)
    }
    set s(nrect) 0
    $w(prev) coords $s(rect0) 0 0 0 0
    stat_text "Registered Regions: $s(nrect)"
}

#----------------------------------------------------------------
# (Combined) Widgets
#----------------------------------------------------------------

proc mb { wn text menu } { menubutton $wn -text $text -menu $menu \
                           -underline 0 -width 8 -relief flat }

proc rl { wn text } { label $wn -text "$text" -width 10 -anchor e }

proc entryscale { wn var command range length } { global l
    entry $wn.e -textvariable $var \
          -justify right -relief sunken -width 4 -font $l(f1) -fg $l(c1)
    scale $wn.s -variable $var -command $command \
          -from       [lindex $range 0] \
          -to         [lindex $range 1] \
          -resolution [lindex $range 2] \
          -length $length -orient horizontal -showvalue false
}

proc sizeline { wn label unit } { global w l
    frame $wn
    pack  $wn -side top -anchor nw
    label $wn.label -text $label -width 10 -anchor e
    label $wn.size -anchor e -relief flat -width 12 -font $l(f1) -fg $l(c1)
    label $wn.unit -text $unit -anchor w -width 6 -padx 4 -relief flat
    pack  $wn.label $wn.size $wn.unit -side left
}

#----------------------------------------------------------------
# Miscellaneous procedures
#----------------------------------------------------------------

proc do_exit {} { global c w
    if $c(tmpdirclear) { clear_tkscandir }
    if {$w(main)=={}} {
        destroy .
    } else {
        destroy $w(main)
    }
}

proc clear_tkscandir {} { global c
    exec sh -c "rm -f $c(tkscandir)/$c(prefile).* $c(tkscandir)/$c(scanout)*"
}

proc stat_text { message } { global w
    $w(stat_text) configure -text "$message"
}

proc time_hhmmss {} {
    set date [open "|date +%H%M%S"]
    set Time [gets $date]
    close $date
    return $Time
}

proc getpid { command } {
    set psList [open "|ps xc"]
    set pid ""
    while {[set i [gets $psList]] != {}} {
        if [regexp "$command" "$i"] {
            lappend pid [lindex $i 0]
        }
    }
    close $psList
    return $pid
}

proc kill_scan_command {} { global s
    set s(pid) [getpid $s(command)]
    if {"$s(pid)" != ""} { foreach i $s(pid) { exec kill -HUP $i } }
}

proc isinside { x y tx ty bx by } {
    if { $x >= $tx && $x <= $bx && $y >= $ty && $y <= $by } { return 1
    } else { return 0 }
}

proc pixelto { unit length } { global s
    return [expr $length/$s(preresolution).0*$s(c$unit)]
}

proc gamma_table { gamma } {
    set table 0
    for {set i 1} {$i < 256} {incr i} {
        set value [expr 255.*pow([expr $i./255.],[expr 1./$gamma])]
        append table ,[format "%0.0f" $value]
    }
    return $table
}

