# This file is a part of TkScan.
#

#
# Treatment of scanned image file

proc Make_Output { prefix i } {
    global s c w file

    # Scanned image name
    set scanned "$c(tkscandir)/$prefix-$i.pnm"

    # Output file name
    # replace hhmmss to $prefix and # to $i in $file(name)
    set p [string last hhmmss $file(name)]
    if {$p >= 0} {
        set f1 [string range $file(name) 0 [expr $p-1]]
        set f2 $prefix
        set f3 [string range $file(name) [expr $p+6] end]
        set ftmp "$f1$f2$f3"
    } else {
        set ftmp $file(name)
    }
    set p [string last # $ftmp]
    if {$p >= 0} {
        set f1 [string range $ftmp 0 [expr $p-1]]
        set f2 $i
        set f3 [string range $ftmp [expr $p+1] end]
        set outfile $f1$f2$f3
    } else {
        set outfile $ftmp
    }

    # Move $scanned to $outfile
    exec mv -f $scanned $file(dir)/$outfile
    if {[info exist w(dirlist)] && [winfo exist $w(dirlist)]} {
        update_dir
    }
    stat_text "Scanning $s(curscan) / $s(nrect) ... $outfile"
    update

    # Do something more if necessary
    if $c(autoview) {
        View $file(dir)/$outfile $i
    }
    if $c(autoconvert) {
        Convert $file(dir)/$outfile
    }
    if $c(autoprint) {
        Print $file(dir)/$outfile $s(tx$i) $s(ty$i) $s(bx$i) $s(by$i)
    }
    if $c(autofax) {
        MakeFax $file(dir)/$outfile
    }

    # This is for using TkScan as fax scanner of TkFax.
    if $c(autofaxif) {
       fax_pbm2fax $file(dir)/$outfile
       exec rm -f $file(dir)/$outfile
    }
}


proc View { fn i } {
    global s c file

    # Which image editor?
    set ImageEditor $c($c(ImageEditor)command)

    # Which image editor window mode?
    if {$c(ImageEditorWinmode) == 1 || $s(nrect) == 0} {
        set geometry "-geometry [format "+%d+%d" [expr $i*100] [expr $i*25]]"
        set f $fn
    } else {
        if {$i < 2} { set file(scanned) "" }
        append file(scanned) " $fn"
        if {$i < $s(nrect)} { return }
        set geometry "-geometry +0+0"
        set f $file(scanned)
    }

    # Gamma correction supporting
    if {$s(gamma_support)==1} {
        switch $ImageEditor {
            xv { set gamma "-gamma $s(gamma) \
                -cgamma $s(gamma_red) $s(gamma_green) $s(gamma_blue)"
            }
            display {
                set gamma "-gamma $s(gamma_red),$s(gamma_green),$s(gamma_blue)"
            }
            gimp {
            }
        }
    } else { set gamma "" }

    # Launch image viewer
    exec sh -c "$ImageEditor $geometry $gamma $f" &
}


proc Convert { fn } {
    global file s c

    # Output filename
    set p [string last . $fn]
    if {$p < 0} {
        set prefix $fn
    } else {
        set prefix [string range $fn 0 [expr $p - 1]]
    }
    set outfile $prefix.$file(surfix)

    # Gamma correction supporting
    if {$s(gamma_support)==1} {
        set gamma "-gamma $s(gamma_red),$s(gamma_green),$s(gamma_blue)"
    } else {
        set gamma ""
    }

    # Run ImageMagic's convert
    exec sh -c "convert $gamma $fn $outfile" &
}


proc Print { fn tx ty bx by } {
    global pr s c

    # Extract prefix from file name
    set p [string last / $fn]
    set q [string last . $fn]
    if {$p < $q} {
        set prefix [string range $fn [expr $p+1] [expr $q-1]]
    } else {
        set prefix [string range $fn [expr $p+1] end]
    }

    # Setup print command and gamma correction
    set print $pr($pr(printer)command)
    if {$s(gamma_support)==1} {
        set gamma "-gamma $s(gamma_red),$s(gamma_green),$s(gamma_blue)"
    } else {
        set gamma ""
    }

    # Compare zoomed image size to paper size
    # If the zoomed image size is larger than the page, fit it to the page.
    switch $pr(paper) {
        A4      { set pwd 595. ; set pht 842. ; set offset 72 }
        Letter  { set pwd 612. ; set pht 792. ; set offset 72 }
        default { set pwd 595. ; set pht 842. ; set offset 72 }
    }
    set rwd [pixelto pt [expr $bx-$tx]]
    set rht [pixelto pt [expr $by-$ty]]
    set zoom [expr $pr(zoom).0/100.0]
    set iwd [expr $rwd*$zoom]
    set iht [expr $rht*$zoom]
    if {$iwd > $pwd} {
        set iwd $pwd
        set zoom [expr $pwd/$rwd]
        set iht [expr $rht*$zoom]
    }
    if {$iht > $pht} {
        set iht $pht
        set zoom [expr $pht/$rht]
        set iwd [expr $rwd*$zoom]
    }

    # Determine the offsets
    # If the offset requested is larger than the available space,
    # fit it to the latter.
    set xspace [expr $pwd-$iwd]
    switch $pr(xoffset) {
        x -
        X {
            if {$pr(zoom)==100} {
                set xoffset [pixelto pt $tx]
            } else {
                set xoffset [expr $xspace/2]
            }
        }
        c -
        C { set xoffset [expr $xspace/2] }
        l -
        L { set xoffset 0 }
        r -
        R { set xoffset $xspace }
        default {
            if { $pr(xoffset) < $xspace } {
                 set xoffset $pr(xoffset)
            } else {
                 set xoffset $xspace
            }
        }
    }
    set yspace [expr $pht-$iht]
    switch $pr(yoffset) {
        y -
        Y {
            if {$pr(zoom)==100} {
                set yoffset [expr $pht-[pixelto pt $by]]
            } else {
                set yoffset [expr $yspace/2]
            }
        }
        c -
        C { set yoffset [expr $yspace/2] }
        b -
        B { set yoffset 0 }
        t -
        T { set yoffset $yspace }
        default {
            if { $pr(yoffset) < $yspace } {
                 set yoffset $pr(yoffset)
            } else {
                 set yoffset $yspace
            }
        }
    }

    # ZOOM from screen size in percetage: This is really used for convert.
    set ZOOM [format "%0.0f" [expr $zoom*7200.0/$s(resolution).0]]

    # Run ImageMagic's convert to generate postscript file.
    set geometry [format "-geometry %0.0f%% -page +%0.0f+%0.0f" \
                  $ZOOM $xoffset $yoffset]
    set convertcmd "convert $gamma $geometry $fn $c(tkscandir)/$prefix.ps"
    if $c(autodelete) {
        set rmcmd "rm -f $fn"
    } else {
        set rmcmd ""
    }
    set printcmd "$print $c(tkscandir)/$prefix.ps"
    set rmpscmd "rm -f $c(tkscandir)/$prefix.ps"
    exec sh -c "$convertcmd ; $rmcmd ; $printcmd ; $rmpscmd" &
}

proc MakeFax { fn } {
    global c
    set p [string last / $fn]
    set q [string last . $fn]
    if {$p >= 0} {
        set dirname [string range $fn 0 $p]
        set prefix [string range $fn [expr $p+1] [expr $q-1]]
    } else {
        set dirname ""
        set prefix [string range $fn [expr $p+1] end]
    }
    set fx $dirname$prefix.g3
    set mkfaxcmd "$c(pbmtofax) $fn > $fx"
    if $c(autodelete) {
        set rmcmd "rm -f $fn"
    }
    exec sh -c "$mkfaxcmd ; $rmcmd" &
}

