#---------------------------------------------------------------
# Procedures for Scanning : Preview, Scan and Make_Output
#----------------------------------------------------------------

proc Preview {} {
    global s c w

    # WHEN STOP BUTTON IS PRESSED WHILE PREVIEWING
    if $s(stop) {
        # kill scan command
        kill_scan_command
        stat_text "Scanning Preview ... Stopped"
        set s(runscan) 0
        set s(stop) 0
        $w(bt).p configure -state normal
        $w(bt).s configure -state normal
        $w(bt).q configure -state disabled
        return
    }

    # BUTTON STATE DURING PREVIEWING
    $w(bt).p configure -state disabled
    $w(bt).s configure -state disabled
    $w(bt).q configure -state normal

    if {$s(runscan) == 0} {
    # LAUNCH COMMAND-LINE SCANNNER DRIVER
        savecur cur
        setcur pre
        settop $s(o) $s(o)
        setbottom $s(maxpwidth) $s(maxpheight)
        image create photo preview -data {}
        stat_text "Scanning Preview ..."
        update
        run_scanner_driver 0 $c(prefile)
        set s(runscan) 1
    } else {
    # CHECK PREVIEWING PROGRESS
        set s(pid) [getpid $s(command)]
        if {$s(pid) == ""} {
        # PREVIEWING IS FINISHED
            set prefile $c(tkscandir)/$c(prefile)
            if { $s($s(premode)format) == "pbm" } {
                exec convert $prefile.pnm $prefile.xbm
                image create bitmap preview -background white -file $prefile.xbm
            } else {
                if {$s(gamma_support)==1} { set gamma $s(pregamma)
                                   } else { set gamma 1 }
                image create photo preview -gamma $gamma -file $prefile.pnm
            }
            set s(runscan) 0
            stat_text "Scanning Preview ... Done"
            update
            $w(bt).p configure -state normal
            $w(bt).s configure -state normal
            $w(bt).q configure -state disabled
            setcur cur
            return
        } else {
        # PREVIEWING IS STILL IN PROGRESS
        }
    }

    # REPEAT UNTIL PREVIEWING IS FINISHED.
    after $s(loopperiod) Preview
}


proc Scan { prefix } {
    global s c w l

    # Return to the state ready for another scanning,
    # when stop button is pressed while scanning.
    if $s(stop) {
        # kill scan command
        kill_scan_command
        stat_text "Scanning $s(curscan) / $s(nrect) ... Stopped"
        if $s(nrect) {
            $w(prev) itemconfigure $s(rect$s(curscan)) -outline $l(c3)
            $w(prev) itemconfigure $s(num$s(curscan)) -fill $l(c3)
        }
        set s(runscan) 0
        set s(curscan) 0
        set s(stop) 0
        $w(bt).p configure -state normal
        $w(bt).s configure -state normal
        $w(bt).q configure -state disabled
        return
    }

    # Disable preview and scan button during scanning
    $w(bt).p configure -state disabled
    $w(bt).s configure -state disabled
    $w(bt).q configure -state normal

    if {$s(runscan) == 0} {
    # Launch command-line scanner driver.
        if {$s(nrect) == 0} {
            stat_text "Scanning $s(curscan) / $s(nrect) ..."
            run_scanner_driver $s(curscan) $prefix-$s(curscan)
        } else {
            incr s(curscan) 1
            stat_text "Scanning $s(curscan) / $s(nrect) ..."
            $w(prev) itemconfigure $s(rect$s(curscan)) -outline $l(c5)
            $w(prev) itemconfigure $s(num$s(curscan)) -fill $l(c5)
            showsize $s(curscan)
            update
            run_scanner_driver $s(curscan) $prefix-$s(curscan)
        }
        set s(runscan) 1
    } else {
    # Check scanning progress.
        set s(pid) [getpid $s(command)]
        if {$s(pid) != ""} {
        # Current scanning is still in progress.
            set csize [format "%0.1f" [expr [file size \
                          $c(tkscandir)/$prefix-$s(curscan).pnm] / 1024.0]]
            set percent [format "%0.0f" [expr $csize / $s(sizeData) * 100]]
            stat_text \
                "Scanning $s(curscan) / $s(nrect) ... $csize / $s(sizeData)"
            set x [format "%0.0f" \
                  [expr ($s(prog_bar_wd) + 4) * $percent.0 / 100]]
            $w(prog_perc) configure -text "$percent%"
            $w(prog_bar) coords $s(sg) 0 0 $x 18
            update
        } else {
        # Current scanning is finished.
            # notify the current scanning is finished.
            set s(runscan) 0
            stat_text "Scanning $s(curscan) / $s(nrect) ... Done"
            $w(prog_perc) configure -text ""
            $w(prog_bar) coords $s(sg) 0 0 0 18
            if $s(nrect) {
                $w(prev) itemconfigure $s(rect$s(curscan)) -outline $l(c3)
                $w(prev) itemconfigure $s(num$s(curscan)) -fill $l(c3)
            }
            update
            # Play with the output of current scanning.
            Make_Output $prefix $s(curscan)
            if {$s(curscan) < $s(nrect)} {
            # Wait until scanner is prepared again for another scanning.
                after [format "%0.0f" \
                [expr $s(scantime).0 * $s(by$s(curscan)) / $s(maxpheight)]]
            } else {
            # All scanning regions are exhasted.
                # Recover the state ready for another scanning.
                set s(curscan) 0
                $w(bt).p configure -state normal
                $w(bt).s configure -state normal
                $w(bt).q configure -state disabled
                # EXIT loopscan
                return
            }
        }
    }

    # Repeat periodically the above process until finished or stopped.
    after $s(loopperiod) Scan $prefix
}

