# This file is a part of TkScan.
# scan-scanwin.tcl

#----------------------------------------------------------------
# Main Window
#----------------------------------------------------------------

proc Window_Scan { wn } { global s c w l

    set w(main) $wn

    #
    # Menubar
    #
    frame $wn.menu -bd 1 -relief flat
    pack $wn.menu -side top -fill x
    mb $wn.menu.f File    $wn.menu.f.m
    mb $wn.menu.q Quick   $wn.menu.q.m
    mb $wn.menu.m Mode    $wn.menu.m.m
    mb $wn.menu.h Help    $wn.menu.h.m
    label $wn.menu.l -text "TkScan $c(version)" -pady 0 \
          -fg red -font -*-times-bold-r-*--14-140-*
    pack $wn.menu.f $wn.menu.q $wn.menu.m $wn.menu.h -side left
    pack $wn.menu.l -side right
    menu $wn.menu.f.m -tearoff false
         $wn.menu.f.m add command -label Preference -command preferenceWindow
         $wn.menu.f.m add command -label "Set current as Default" \
                      -command "savecur Default"
         $wn.menu.f.m add command -label "Save current config" \
                      -command "savesettings"
         $wn.menu.f.m add separator
         $wn.menu.f.m add command -label Quit -command do_exit
    menu $wn.menu.q.m -tearoff false
         $wn.menu.q.m add command -label "Copy Machine (Gray)" \
                      -command setcopymachine_gray
         $wn.menu.q.m add command -label "Copy Machine (Color)" \
                      -command setcopymachine_color
         $wn.menu.q.m add command -label "Fax Scan" \
                      -command setfaxmachine
         $wn.menu.q.m add command -label "Scanner Default" \
                      -command setscannerdefault
    menu $wn.menu.m.m -tearoff false
    foreach i $c(mode_quick_set) {
        set qmodename [lindex $i 0]
        $wn.menu.m.m add command -command "setquickmode $qmodename" \
                              -label $qmodename
    }
    menu $wn.menu.h.m -tearoff false
         $wn.menu.h.m add command -label About  -command aboutWindow
         $wn.menu.h.m add command -label Guide  -command usageWindow

    #
    # Separator - just for decoration.
    #
    canvas $wn.sep1  -relief sunken -height 0 -borderwidth 1
    pack $wn.sep1 -side top -fill x

    #
    # Left frame - preview image canvas
    #
    frame $wn.left -bd 5 -relief flat
    pack $wn.left -side left -anchor nw -fill y
    set w(prev) $wn.left.preview
    canvas $w(prev) -relief sunken
    pack $w(prev) -side top
    #
    # Configuring the preview canvas will be done elsewhere.
    # Mouse bindings on the preview canvas
    # 
    bind $w(prev) <ButtonPress-1>	"settop		%x %y"
    bind $w(prev) <B1-Motion>		"setbottom	%x %y"
    bind $w(prev) <ButtonPress-2>	"registrect	%x %y"
    bind $w(prev) <ButtonPress-3>	"deleterect	%x %y"
    bind $w(prev) <Double-Button-3>	"deleteallrect"

    #
    # Right frame -- output, scanning mode and geometry control
    #
    frame $wn.right -bd 5 -relief flat
    pack $wn.right -side left -expand yes -fill both

    #
    # Output control
    #
    set w(ou) $wn.right.output
    frame $w(ou) -bd 2 -relief groove
    frame $w(ou).u
    pack $w(ou).u -side top -fill x
    rl $w(ou).u.l "Output to"
    entry $w(ou).u.e -textvariable file(name) -width 17 -fg $l(c1) -font $l(f1)
    button $w(ou).u.b -text " " -command Window_File \
           -anchor c -width 0 -relief raised -padx 2 -pady 1 \
           -bg $l(c7) -activebackground $l(c7)
    pack $w(ou).u.l $w(ou).u.e -side left -fill x
    pack $w(ou).u.b -side right -fill x
    set w(outcontrolbutton) $w(ou).u.b

    #
    # Scanning mode selection
    # Mode - Resolution - Other options
    #
    set w(mo) $wn.right.mode
    frame $w(mo) -bd 2 -relief groove
    frame $w(mo).m
    frame $w(mo).r
    pack $w(mo).m $w(mo).r -side top -anchor nw -fill x
    rl $w(mo).m.label "Mode"
    rl $w(mo).r.label "Resolution"
    menubutton $w(mo).m.mode -menu $w(mo).m.mode.m \
               -anchor w -width 16 -padx 5 -pady 2 -relief ridge -fg $l(c1)
    entry $w(mo).r.entry -textvariable s(resolution) \
          -justify right -relief sunken -width 4 -font $l(f1) -fg $l(c1)
    scale $w(mo).r.scale -variable s(resolution) -command setresolution \
          -from [lindex $s(resolutionRange) 0] \
          -to [lindex $s(resolutionRange) 1] \
          -resolution [lindex $s(resolutionRange) 2] \
          -length 100 -orient horizontal -showvalue false
    button $w(mo).m.button -text " " \
           -command optionWindow \
           -anchor c -width 0 -relief raised -padx 2 -pady 1 \
           -bg $l(c7) -activebackground $l(c7)
    pack $w(mo).m.label $w(mo).m.mode -side left -fill x
    pack $w(mo).m.button -side right -fill x
    pack $w(mo).r.label $w(mo).r.entry $w(mo).r.scale -side left
    menu $w(mo).m.mode.m -tearoff false
    foreach i $s(modeList) { set modename [lindex $i 0]
        $w(mo).m.mode.m add command -label $modename \
                                    -command "setmode $modename"
    }
    set w(optionbutton) $w(mo).m.button

    #
    # Scanning geometry control
    # Canvas widget is used.
    #
    set w(ge) $wn.right.geometry
    frame $w(ge) -bd 2 -relief groove
    canvas $w(ge).xy -width 210 -height 80 -bd 1 -relief flat
    pack $w(ge).xy -fill x
    #
    # Fine tuning buttons
    #
    set w(ft) $w(ge).xy
    set finetune_buttons {
        { tx- {  8 17 } {  8 33 } {  0 25 } }
        { tx+ { 13 17 } { 13 33 } { 21 25 } }
        { bx- { 38 17 } { 38 33 } { 30 25 } }
        { bx+ { 43 17 } { 43 33 } { 51 25 } }
        { ty- { 17  8 } { 33  8 } { 25  0 } }
        { ty+ { 17 13 } { 33 13 } { 25 21 } }
        { by- { 17 38 } { 33 38 } { 25 30 } }
        { by+ { 17 43 } { 33 43 } { 25 51 } }
    }
    set xs 100
    set ys 21
    $w(ft) create rectangle [expr 10+$xs] [expr 10+$ys] \
                            [expr 40+$xs] [expr 40+$ys] -outline blue
    foreach i $finetune_buttons {
        set btag [lindex $i 0]
        for {set j 1} {$j<=3} {incr j} {
            set x$j [expr [lindex [lindex $i $j] 0] +$xs]
            set y$j [expr [lindex [lindex $i $j] 1] +$ys]
        }
        $w(ft) create polygon $x1 $y1 $x2 $y2 $x3 $y3 -fill black -tag $btag
        $w(ft) bind $btag <Any-Enter> "$w(ft) itemconfig current -fill red"
        $w(ft) bind $btag <Any-Leave> "$w(ft) itemconfig current -fill black"
        $w(ft) bind $btag <ButtonPress> "set s(xx) 0; finetune $btag"
        $w(ft) bind $btag <ButtonRelease> "set s(xx) 1"
    }
    #
    # Coordinates display
    #
    label  $w(ft).flabel -text "Fine Tune" -padx 0 -pady 0
    $w(ft) create window [expr 54+$xs] [expr 25+$ys] \
           -window $w(ft).flabel -anchor w
    $w(ft) create text [expr 8+$xs] [expr 15+$ys] -tag ul -anchor se \
           -fill $l(c1) -font $l(f1)
    $w(ft) create text [expr 42+$xs] [expr 35+$ys] -tag lr -anchor nw \
           -fill $l(c1) -font $l(f1)
    #
    # Label and Buttons
    #
    rl $w(ft).label "Geometry"
    label  $w(ft).ulabel -text "Length Unit"
    menubutton $w(ft).unit -text $s(unit) -menu $w(ft).unit.m \
                        -width 4 -pady 0 -relief ridge -fg $l(c1) -bg skyblue
    menu $w(ft).unit.m -tearoff false
    foreach i $s(unitList) { set label [lindex $i 0]
        $w(ft).unit.m add command -label $label -command \
                 "setunit $label ; $w(ft).unit configure -text $label"
    }
    menubutton $w(ft).preset -text "Preset" -menu $w(ft).preset.m \
                     -width 5 -padx 2 -pady 1 -relief ridge -bg skyblue
    menu $w(ft).preset.m -tearoff false
    foreach i $c(size_quick_set) {
        set qpapername [lindex $i 0]
        $w(ft).preset.m add command -command "setquickpaper $qpapername" \
                              -label $qpapername
    }
    button $w(ft).regist -text Regist -command {registrect $s(tx0) $s(ty0)} \
                 -width 5 -padx 1 -pady 0 -relief ridge -bg skyblue
    button $w(ft).delete -text Delete -command {deleterect $s(tx0) $s(ty0)} \
                 -width 5 -padx 1 -pady 0 -relief ridge -bg skyblue
    button $w(ft).clean -text Clean  -command deleteallrect \
                 -width 5 -padx 1 -pady 0  -relief ridge -bg skyblue
    $w(ft) create window   0   0 -window $w(ft).label  -anchor nw
    $w(ft) create window 102   0 -window $w(ft).ulabel -anchor nw
    $w(ft) create window 177   0 -window $w(ft).unit   -anchor nw
    $w(ft) create window   0  40 -window $w(ft).regist -anchor nw
    $w(ft) create window  46  41 -window $w(ft).preset -anchor nw
    $w(ft) create window   0  62 -window $w(ft).delete -anchor nw
    $w(ft) create window  45  62 -window $w(ft).clean  -anchor nw

    #
    # Size : Real, Screen, Data
    #
    set w(sz) $wn.right.size
    frame $w(sz) -bd 2 -relief groove
    sizeline $w(sz).rs "Real Size" "mm^2"
    sizeline $w(sz).ss "Screen Size" "pixel^2"
    sizeline $w(sz).ds "Data Size" "KB"

    #
    # Buttons for preview and scan
    #
    set w(bt) $wn.right.buttons
    frame $w(bt) -bd 1 -relief flat
    button $w(bt).p -text Preview -command "Preview" \
           -width 5 -pady 4 -bg #66cdaa
    button $w(bt).s -text SCAN -command {Scan [time_hhmmss]} \
           -width 10 -pady 4 -bg #66cdaa
    button $w(bt).q -text Stop -command "set s(stop) 1" \
           -width 3 -pady 4 -state disabled -bg #66cdaa
    pack $w(bt).p $w(bt).s $w(bt).q -side left -expand yes -fill x
    #
    # Mouse bindings on buttons
    #
    bind $w(bt).q <Double-Button-1> {
        set s(pid) [getpid $s(command)]
        if {"$s(pid)" != ""} { foreach i $s(pid) { exec kill -9 $i } }
        set s(stop) 0
        set s(runscan) 0
        $w(bt).p configure -state normal
        $w(bt).s configure -state normal
        $w(bt).q configure -state disabled
    }

    #
    # Message line
    # Scanning progress: percentage in  bar and number
    #
    set w(st) $wn.right.status
    set w(stat_text) $w(st).text
    set w(stat_prog) $w(st).prog
    set w(prog_bar) $w(stat_prog).bar
    set w(prog_perc) $w(stat_prog).percent
    set s(prog_bar_wd) 173
    #
    frame $w(st) -bd 2 -relief groove
    label $w(stat_text) -anchor w -relief flat -font $l(f1)
    frame $w(stat_prog)
    pack $w(stat_text) $w(stat_prog) -side top -fill x
    canvas $w(prog_bar) -width $s(prog_bar_wd) -height 15 -bd 1 -relief ridge
    label $w(prog_perc) -width 5 -padx 1 -pady 0 -anchor e -bd 1 -relief ridge
    pack $w(prog_bar) $w(prog_perc) -side left
    set s(sg) [$w(prog_bar) create rectangle 0 0 0 18 -fill $l(c6)]

    pack $w(ou) $w(mo) $w(ge) $w(sz) $w(bt) $w(st) \
         -side top -expand yes -fill x

}

# End of scan-scanwin.tcl
