/*
  EPSI preview to PBM converter

  Boris Tobotras <boris@xtalk.msk.su>
  Copyright (c) 1998

  Distributed under GNU General Public License
*/

# include <assert.h>
# include <ctype.h>
# include <pbm.h>
# include <stdio.h>
# include <unistd.h>

void EPSIerror( void );
int readhexbyte( FILE * );

main( int argc, char *argv[] )
{
	FILE *in = stdin;
	char buf[ 1024 ];			/* Adobe says 255 ought to be
								   enough */ 
	int width, height, depth;
	bit **data;
	
	if ( argc != 1 ) {
		in = fopen( argv[ 1 ], "r" );
		if ( in == NULL ) {
			perror( argv[ 1 ] );
			exit( 1 );
		}
	}
	
	while ( 1 ) {
		if ( fgets( buf, 1024, in ) == NULL
			 && feof( in )
			 && !strncmp( buf, "%%BeginProlog", 13 ) )
			EPSIerror();

		if ( !strncmp( buf, "%%BeginPreview", 14 ) )
			break;
	}
	
	if ( sscanf( buf, "%%%%BeginPreview: %d %d %d", &width, &height,
				 &depth ) != 3 )
		EPSIerror();

	if ( depth != 1 ) {
		fprintf( stderr, "Sorry, can only cope with black&white previews.\n" );
		exit( 1 );
	}

	pbm_init( &argc, argv );
	data = pbm_allocarray( width, height );
	assert( data );
	{
		int i, j;
		for ( i = 0; i < height; ++i ) {
			for ( j = 0; j < width; ) {
				int Byte = readhexbyte( in );
				int bit;
				int bitsRest = 8;
				if ( j + 8 > width )
					bitsRest = width - j;
				for ( bit = bitsRest; bit; --bit ) {
					data[ i ][ j++ ] = 
						( ( ( Byte & ( 1 << bit ) ) == 0 ) ? PBM_WHITE
						  : PBM_BLACK );
				}
			}
		}
	}
	pbm_writepbm( stdout, data, width, height, 0 );
}

void EPSIerror( void ) 
{
	fprintf( stderr, "Illegal EPSI file\n" );
	exit( 1 );
}

int readhexchar( FILE *in )
{
	while ( 1 ) {
		int c = fgetc( in );
		if ( c == EOF )
			EPSIerror();
		if ( c >= '0' && c <= '9' )
			return c - '0';
		if ( c >= 'a' && c <= 'f' )
			return c - 'a' + 10;
		if ( c >= 'A' && c <= 'F' )
			return c - 'A' + 10;
	}
}

int readhexbyte( FILE *in )
{
	return ( readhexchar( in ) << 4 ) | readhexchar( in );
}

