/*
 * box.C
 * 
 * Drawing boxes
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"

static Widget boxVariant;
advertise int box_variant InitializeWith(0);

advertise void create_box_variants(Widget parent)
{
  boxVariant = 
    create_choice(parent, CHOICE_MODE, "inputVariant", NIL, &box_variant);
  add_to_choice("rectangle");
  add_to_choice("square");
}

void Box::setchoice(void)
{
  manage_variant(boxVariant);
}  
  
static void squarify_mouse(pl_vec &mousep, const pl_vec& first)
// make mouse position a square with first
{
  s_coord dx, dy;

  dx = mousep.x() - first.x();
  dy = mousep.y() - first.y();
  if (fabs_pp(dx) > fabs_pp(dy))
    dy = (dy >= 0) ? fabs_pp(dx) : -fabs_pp(dx);
  else
    dx = (dx >= 0) ? fabs_pp(dy) : -fabs_pp(dy);
  mousep = first  + pl_vec(dx, dy);
}

void Box::push(pl_vec& mousep, int button, Boolean)
{
  if (drawing_mode != DRAWING) {
    // left mouse button pressed, starting line mode
    clear_selection();
    v.newsize(1);
    v[0] = mousep;
    curmp = mousep;
    nonidle(DRAWING);
    mouse_msg("", "opposite corner", "");
    redraw_pup();
  } else {
    if (button != MIDDLE_MOUSE)
      return;
    // second point, we are done
    pl_vec mp = mousep;
    if (box_variant == 1)
      squarify_mouse(mp, v[0]);
    Line *bx = new Box();
    bx->v.newsize(4);
    bx->v[0] = v[0];
    bx->v[2] = mp;
    bx->v[1] = pl_vec(mp.x(), v[0].y());
    bx->v[3] = pl_vec(v[0].x(), mp.y());
    bx->setcurrent();
    if (!bx->fill.is_empty() && !enable_stroke_bt.on())
      bx->stroke.mkempty();
    pic->add_object(bx);
    object_added();
    idlefy(2);
  }
}

Box::Box(s_coord wd, s_coord ht)
// generate box, symmetric to origin, with current settings
{
  setclosed(TRUE);
  v.newsize(4);
  v[0] = pl_vec(-wd/2, -ht/2);
  v[1] = v[0] + pl_vec(wd, 0);
  v[2] = v[0] + pl_vec(wd, ht);
  v[3] = v[0] + pl_vec(0, ht);
  setcurrent();
}

Box::Box(const pl_vec& ll, const pl_vec& ur)
// generate box, with current settings
{
  setclosed(TRUE);
  v.newsize(4);
  v[0] = ll;
  v[2] = ur;
  v[1] = pl_vec(ur.x(), ll.y());
  v[3] = pl_vec(ll.x(), ur.y());
  setcurrent();
}

void Box::mouse(const pl_vec& mousep, Boolean)
{
  curmp = mousep;
  if (box_variant == 1)
    squarify_mouse(curmp, v[0]);
}

void Box::redraw(void)
// redraw popup plane
{
  if (edit_object)
    Line::redraw();
  else {
    canvas(COL_CREATION);
    draw_rectangle(v[0], curmp);
  }
}
