/*
 * callback.C
 * 
 * diverse Callback routines for Widgets, Choices, and Buttons
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"

//
// Object type selection widget
//

advertise void object_type_cb(IpeButton *button)
// set drawing mode
{
  Object_type t = Object_type(button - object_type_button);
  DEBUG(DBG_CB, "CALLBACK: object type ", t);

  Object_type told = curobj->type();
  if (drawing_mode == IDLE) {
    if (t != told)
      sel_mode(Object_type(t));
  } else {
    object_type_button[told].set(told == curobj->type());
    object_type_button[t].set(t == curobj->type());
  }
}

//
// Zoom Widget
//

advertise void zoom_cb(Widget, XtPointer client_data, XtPointer)
{
  zoom_op(int(client_data));
}

//
// Font and font size selection choice
//

static void text_set_font(Iobject *ob)
{
  ((Text *) ob)->setfont(font_choice[mipe_mode]);
}

static void text_set_size(Iobject *ob)
{
  ((Text *) ob)->setsize(fontsize_list
			 [mipe_mode][fontsize_choice[mipe_mode]]);
}

advertise void text_choice_cb(ChoiceArgs choice)
{
  if (selection()) {
    if (choice == CHOICE_FONTSIZE) {
      pic_traverse(TEXT, text_set_size);
    } else {
      pic_traverse(TEXT, text_set_font);
    }
    undo_changed();
    redraw_canvas();
  }
}

//
// Linestyle and line width selection choice
//

advertise void line_choice_cb(ChoiceArgs choice)
{
  Iobject *ob;
  if (selection()) {
    for (ob = pic->first; ob; ob = ob->next)
      if (ob->sel != UNSELECTED)
	if (choice == CHOICE_LINE_WIDTH)
	  ob->setlwidth(line_width_list[line_width_choice]);
	else
	  ob->setdash(linestyle_choice);
    undo_changed();
    redraw_canvas();
  }
// FORMS fl_redraw_object(line_arrow_obj);
}

//
// Arrow selection widget
//

static void line_set_arrow(Iobject *ob)
{
  ((Line *) ob)->setarrow(arrow_type);
}

static void spline_set_arrow(Iobject *ob)
{
  ((Spline *) ob)->setarrow(arrow_type);
}

static void arc_set_arrow(Iobject *ob)
{
  ((Arc *) ob)->setarrow(arrow_type);
}

advertise void line_arrow_cb(IpeButton *)
{
  arrow_type = (left_arrow_bt.on() ? 1 : 0)
    | (right_arrow_bt.on() ? 2 : 0);
  
  if (drawing_mode == IDLE && selection()) {
    pic_traverse(LINE, line_set_arrow);
    pic_traverse(SPLINE, spline_set_arrow);
    pic_traverse(ARC, arc_set_arrow);
    undo_changed();
    redraw_canvas();
  }
}

