/* -*-C++-*-
 *
 * data.C
 * 
 * Global data items in Ipe
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"

//
// these are initialized from AppData
//

advertise Boolean monochrome;
advertise int mipe_mode;
advertise int delta_alpha_choice;
advertise int linestyle_choice;
advertise int line_width_choice;
advertise int arrow_type;
advertise int font_choice[2];
advertise int fontsize_choice[2];
advertise int current_color[2];
advertise int grid_size_choice;
advertise Boolean grid_visible;

advertise s_coord select_distance;
advertise s_coord snap_distance;

advertise s_coord arrow_size[2];
advertise s_coord mark_size[2];

advertise short_rr     linestyle_list;
advertise s_coordreray line_width_list;
advertise s_coordreray grid_size_list;
advertise s_coordreray delta_alpha_list;
advertise s_coordreray fontsize_list[2];

advertise charp_rr	ium_directory;

//
// ----------------------------------------------------------------------
//

advertise int		page_number;
advertise Groupp_rr	pages;
advertise Group		*cut_page;

advertise Group *pic;
advertise Iobject *curobj;
advertise Boolean edit_object;
advertise Iobject *saved_curobj;
advertise Drawing_mode drawing_mode;
advertise Iobject *cut_buffer;

advertise pl_vec canvas_origin;
advertise pl_vec canvas_pan;
advertise s_coord zoom_factor;
advertise pl_vec screen_factor;

advertise pl_vec curmp;

advertise Boolean fixpoint_set;
advertise pl_vec fixpoint;
advertise pl_angle axis_dir;
advertise pl_vec snap_base;

advertise long max_nvertex;

advertise Boolean gs_lostsync;

// file handling and io

advertise char		filename[MAX_FILENAME_LENGTH];
advertise char		newfilename[MAX_FILENAME_LENGTH];
advertise char_rr	new_pspreamble;
advertise char_rr	new_latexpreamble;
advertise Boolean	use_new_preamble;

advertise Boolean	ps_in_defd[MAX_NUM_FIELDS];
advertise s_coord	ps_in_value[MAX_NUM_FIELDS];
advertise pl_vecreray	ps_in_array;
advertise char_rr	ps_in_string;
advertise float		ps_in_color[2][3];
advertise Transform	ps_in_transform;
advertise Boolean	ps_okay;
advertise Boolean	text_objects_saved;
advertise pl_vec	save_offset;


