/*
 * icon.C
 * 
 * the penguin icon
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"
#include <Xm/Label.h>

#include "Icons/penguins.xpm"

advertise void create_penguin(Widget icon)
{
  unsigned long pixel[penguins_ncolors];
  allocate_colors(penguins_ncolors, penguins_colors, pixel);

  char *bits = new char[DefaultDepth(display, screen_num) *
			penguins_height *
			int((penguins_width + 32) / 8)];
  
  XImage *ximg = XCreateImage(display,
			      DefaultVisual(display, screen_num),
			      DefaultDepth(display, screen_num),
			      XYPixmap, 0, bits,
			      penguins_width, penguins_height,
			      32, 0);

  for (int x = 0; x < penguins_width; x++) {
    for (int y = 0; y < penguins_height; y++) {
      XPutPixel(ximg, x, y, pixel[penguins_pixels[y][x] - 0x60]);
    }
  }
  
  Pixmap pengyPix = XCreatePixmap(display,
				  DefaultRootWindow(display),
				  penguins_width, penguins_height,
				  DefaultDepth(display, screen_num));

  XPutImage(display, pengyPix, DefaultGC(display, screen_num),
	    ximg, 0, 0, 0, 0, penguins_width, penguins_height);

  XDestroyImage(ximg);
  
  XtVaSetValues(icon, XmNlabelPixmap, pengyPix, NIL);
}


