/* -*-C++-*-
 *
 * iface.h
 * 
 * Header file for the Ipe user interface
 *
 * Code in interface.C, menus.C, configuration.C
 *
 * $Modified: Monday, September 19, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".

 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef IPE_H
#include "ipe.h"
#else

#include <Xm/Xm.h>
#ifdef MIXED
#include <gl/gl.h>
#endif

const int LEFT_MOUSE   = Button1;
const int MIDDLE_MOUSE = Button2;
const int RIGHT_MOUSE  = Button3;

//
// data structure for application resources
//

//
// the Application entries retrieved from the
// Application defaults file, Resources, and Command line options
//
// the fixed entries (marked) are used directly from 'app',
// all other entries are copied into data
//

typedef struct {
  int debug;			//
  Boolean make_backups;		// 
  Boolean mipe_mode;
  Boolean monochrome;
  Boolean private_colors;	//
  int delta_alpha_choice;
  int linestyle_choice;
  int line_width_choice;
  int arrow_type;
  int font_choice[2];
  int fontsize_choice[2];
  int current_color[2];
  int circle_variant;
  int arc_variant;
  int mark_variant;
  int grid_size_choice;
  float arrow_size[2];
  float mark_size[2];
  Boolean snap_self;
  Boolean enable_undo;
  Boolean enable_latex_box;
  Boolean enable_fifi;
  Boolean enable_interior;
  Boolean enable_zoom_pan;
  Boolean enable_stroke;
  Boolean enable_3_spline;
  float select_distance;
  float snap_distance;
  Boolean grid_visible;
  Boolean show_shortcuts;	// 
  float spline_precision;	// 
  int undo_limit;		// 
  char *color[16];
  char *sys_color[10];
  float font_scale;	        //
  float edit_font_scale;	//
  char *ghostscript_name;	//
  char *latex_command;		//
  char *print_command;
  char *help_command;           //
  char *dvips_command;		//
  char *tmp_directory;		//
  char *ium_directories;	//
  char *ps_preamble;
  char *preview_command[2];
  char *latex_preamble[2];
  char *font_name_gl[8];	//
  char *font_name_x[8];		//
  char *linestyle_list;
  char *line_width_list;
  char *grid_size_list;
  char *delta_alpha_list;
  char *fontsize_list[2];
  char *iums;
  char *more_iums;
} AppData;

enum MenuFunction {
  FILE_FIND, FILE_SAVE, FILE_WRITE, FILE_PREVIEW_PG, FILE_INSERT,
  FILE_PREVIEW_ALL, FILE_PRINT_PG, FILE_PRINT_ALL, FILE_QUIT,
  STRUC_UNDO, STRUC_GROUP, STRUC_UNGROUP, STRUC_FRONT,
  STRUC_BACK, STRUC_SELECT_ALL, STRUC_SELECT_TYPE, STRUC_CUT, STRUC_COPY,
  STRUC_YANK, STRUC_EDIT, STRUC_PROPERTIES, STRUC_DELETE, STRUC_DUPLICATE,
  ALIGN_LEFT, ALIGN_RIGHT, ALIGN_TOP, ALIGN_BOTTOM,
  ALIGN_HCENTER, ALIGN_VCENTER, ALIGN_CENTER,
  MISC_NORMAL, MISC_FIT_ALL, MISC_FIT_SELECTED, MISC_GRID_VISIBLE,
  MISC_GS_KILL, MISC_CONFIGURATION, MISC_STATS,
  PAGE_NEXT, PAGE_PREVIOUS, PAGE_FIRST, PAGE_LAST,
  PAGE_NEW, PAGE_CUT, PAGE_YANK,
  END_ENTRY };

enum ChoiceArgs {
  CHOICE_MODE = 0, CHOICE_GRIDSIZE, CHOICE_DALPHA, CHOICE_FONTSIZE,
  CHOICE_FONT, CHOICE_LINE_WIDTH, CHOICE_LINESTYLE };

enum Menus { FILE_MENU = 0, STRUC_MENU, ALIGN_MENU, MISC_MENU,
	     PAGE_MENU, FIRST_IUM_MENU, SECOND_IUM_MENU, LAST_MENU };

enum IpeOperationType {
  MENU_OP, BUTTON_OP, SELMODE_OP, MISC_OP, PREFIX_OP, IUM_OP };

struct KeyState {
  Boolean shift, control;
};

class IpeButton;
typedef void (*IpeCallback)(void);
typedef void (*IpeButtonCallback)(IpeButton *);
typedef void (*IpeChoiceCallback)(ChoiceArgs choice);
typedef void (*IpeStringCallback)(char *string);

/////////////////////////// IPE BUTTON /////////////////////////////

class IpeButton {
private:
  Boolean value;
  IpeButtonCallback callback;
  Widget  w;
  unsigned long background, highlight;
public:
  void realize(Widget parent, char *name, char *label_or_bits = NIL,
	       Boolean v = FALSE, IpeButtonCallback cb = NIL,
	       int width = 0, int height = 0);
  Boolean on(void) { return value; }
  void set(Boolean v);
  void toggle();
  void set_sensitive(Boolean s) { XtSetSensitive(w, s); }
};

///////////////////////// IPE OPERATIONS ///////////////////////////

struct IumDescription {
  char *exec;
  char *argument;
  unsigned long flags;
  char *prompt;
  char *persist;
};

const unsigned long  IUM_IS_IPE    = 0x8000;
const unsigned long  IUM_NO_RAW    = 0x0001;
const unsigned long  IUM_NO_DATA   = 0x0002;
const unsigned long  IUM_NO_FILE   = 0x0004;
const unsigned long  IUM_FILENAME  = 0x0100;
    
struct IpeOperation {
  IpeOperationType type;
  char *keys;
  char *label;
  Boolean in_drawing;
  union {
    struct {
      void (*func)(int);
      int argument;
    } function;
    IpeButton *button;
    IumDescription ium;
  };
};

DeclareReray(IpeOperation_rr, IpeOperation);

///////////////////////// THE IUMRC FILE ////////////////////////

typedef struct {
  char *keyword;
  char *contents;
} IumrcEntry;

DeclareReray(Iumrc_rr, IumrcEntry);

////////////////////////////// FONTS //////////////////////////////

#ifdef MIXED
struct IpeFont {
  float		size;
  fmfonthandle 	fh;
};
#else
struct IpeFont {
  float		fsize;
  XFontStruct   *xfs;
};
#endif

DeclareReray(Font_rr, IpeFont);

/////////////////////////// IPE COLOR //////////////////////////////

class IpeColor {
private:
  float		red, green, blue;
  Pixel		pixel;
  IpeColor	*next;
  Boolean	pixeled;
friend class IColor;
friend void initialize_ipe_colors(void);
};

extern IpeColor *black_color;

class IColor {
private:
  IpeColor *col;
  void mkpixel(void);
  IpeColor *find_color(float, float, float);
public:
  IColor(void)			{ col = NIL;}

  // sets color to current setting (False -> stroke, True -> Fill)
  void setcurrent(Boolean);

  Boolean is_empty(void)	{ return (col == NIL); }
  void mkempty(void)		{ col = NIL;}
  void mkblack(void)		{ col = black_color;}

  Boolean parse(char *);
  
  unsigned long pixel(void);

  void setcol(void);
  void syscol(short);

  void save(ostream&, char *ipe, char *ps);
  void save_latex(ostream&);
  void read(int);
  
friend void initialize_ipe_colors(void);
  Boolean operator== (IColor &b) { return col == b.col; }
  Boolean operator!= (IColor &b) { return col != b.col; }
};

enum { COL_SELECTION = 0, COL_CREATION, COL_EDIT, COL_MOVING,
       COL_PANNING, COL_DRAGGING, COL_FIXPOINT, COL_GRID,
       COL_BACKGROUND, COL_LAST };

/////////////////////////// EXTERNALS //////////////////////////////////

inline void set_label(Widget w, const char *str)
{
  XtVaSetValues(w, XtVaTypedArg,
		XmNlabelString, XmRString, str, strlen(str) + 1,
		NIL);
}

#endif
