/* -*-C++-*-
 *
 * ipe.h
 * 
 * This is the main header file of Ipe
 *
 * Last $Modified: Tue Dec 19 00:25:20 1995 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".

 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * SIGNAL_HANDLER_ARGUMENT should be such that a function 'handler' defined
 * as  'void handler(SIGNAL_HANDLER_ARGUMENT)' can be used in a
 * signal handler setup 'signal(SIG_XXX, handler);'
 */

#ifdef LONG_SIGNAL_HANDLER_ARG
#define SIGNAL_HANDLER_ARGUMENT int, ...
#else
#define SIGNAL_HANDLER_ARGUMENT int
#endif

//
//----------------------------------------------------------------------
//

#ifndef IPE_H
#define IPE_H

#include <plageo.h>
#include "transform.h"

#include <Xm/Xm.h>

#ifdef MIXED
#include <gl/gl.h>
#include <fmclient.h>
#endif

#define NIL NULL

const int MAX_LINE_LENGTH       = 1024;
const int MAX_FILENAME_LENGTH   = 256;
const int MAX_NUM_FIELDS        = 16;
const int TRANSFORM_STACK_DEPTH = 16;
const int MAX_REQUEST_LENGTH    = 10000;
const int MAX_X_FONTNAMES	= 50;
const int MAX_UNDO		= 16;

const int MAX_COLORS		= 256;
const float COLOR_REDUCE_RATE   = 0.8;

extern char *ipe_version;

#include "iface.h"
#include "igraphics.h"
#include "itypes.h"
#include "advertise.h"

#define DEBUG(mask,a,b) { if (app.debug & mask) {cerr << a << b << "\n";} }
#define DBG_LATEX 1
#define DBG_GL    2	
#define DBG_CB    4
#define DBG_GS    8
#define DBG_PARM  16
#define DBG_GFX   32
#define DBG_IUM   64

#endif

