/*
 * main.C
 * 
 * This is the main module of ipe
 *
 * $Modified: Monday, September 19, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"
#include <unistd.h>

// get Ipe version
char *
#include "version.h"
;

advertise char *ipe_version;

advertise Display *display;
advertise int screen_num;

static Iobject *possible_object[NUM_OBJECT_TYPES];

static void make_object_types(void)
{
  Line *l;
  Spline *s;
  
  possible_object[LINE] = l = new Line;
  l->setclosed(FALSE);
  possible_object[POLYGON] = l = new Line;
  l->setclosed(TRUE);
  possible_object[SPLINE] = s = new Spline;
  s->setclosed(FALSE);
  possible_object[SPLINEGON] = s = new Spline;
  s->setclosed(TRUE);
  possible_object[TEXT] = new Text;
  possible_object[CIRCLE] = new Circle;
  possible_object[MARK] = new Mark;
  possible_object[BOX] = new Box;
  possible_object[ARC] = new Arc;
}  

advertise void sel_mode(Object_type t)
{
  if (t >= NUM_OBJECT_TYPES)
    return;
  Object_type told = curobj->type();
  curobj = possible_object[t];
  object_type_button[told].set(told == curobj->type());
  object_type_button[t].set(t == curobj->type());
  standard_mouse_msg();
  curobj->setchoice();
}

//////////////////////////// MAIN //////////////////////////////////////

int main(int argc, char **argv)
{
  ipe_version = IPEVERSION;

  char *firstfile = load_options_and_resources(&argc, argv);
  
#ifdef MIXED
  fminit();
#endif

  signal_setup();
  
  // init empty drawing

  strcpy(filename, "");
  pages.newsize(2);
  page_number = 1;
  pages[0] = new Group;
  pic = pages[1] = new Group;
  canvas_pan = pl_vec(0, 0);

  use_new_preamble = FALSE;
  new_latexpreamble.newsize(0);
  new_pspreamble.newsize(0);
  
  zoom_factor = 1.0;
  screen_factor = pl_vec(1.0, 1.0);
  fixpoint_set = FALSE;
  fixpoint = pl_vec(0,0);
  
  make_object_types();
  curobj = possible_object[LINE];
  drawing_mode = IDLE;
  edit_object = FALSE;
  cut_buffer = NIL;
  cut_page = NIL;

  // Create the user interface
  display = XtDisplay(topLevel);
  screen_num  = DefaultScreen(display);

  create_widgets();

  initialize_graphics();
  
  standard_mouse_msg();
  undo_init();

  show_zoom();
  show_pagenum();
  show_filename();
  show_m_ipe();
  show_operation("", "");
  
  if (firstfile) {
    // specified a file on command line, try to load it
    find_file(firstfile);
  }

  char buf[32];
#ifdef MIXED
  sprintf(buf, "Ipe version %s GL", ipe_version);
#else
  sprintf(buf, "Ipe version %s X", ipe_version);
#endif
  put_msg(buf);

  XtAppMainLoop(app_context);
  return 0;
}

