/*
 * mexplain.C
 * 
 * the mouse explainer
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"
#include <Xm/Form.h>
#include <Xm/Label.h>

#include "Icons/mouse.xbm"

static char left_msg[64], mid_msg[64], right_msg[64];
Widget leftMouse, middleMouse, rightMouse;

advertise void show_mouse_msg(void)
{
  set_label(leftMouse,   left_msg);
  set_label(middleMouse, mid_msg);
  set_label(rightMouse,  right_msg);
}

advertise void mouse_msg(char *left, char *mid, char *right)
{
  strcpy(left_msg, left);
  strcpy(mid_msg, mid);
  strcpy(right_msg, right);
// FORMS if (canvas_obj->belowmouse)
  show_mouse_msg();
}

advertise void blank_mouse_msg(void)
{
  set_label(leftMouse,   "");
  set_label(middleMouse, "");
  set_label(rightMouse,  "");
}

advertise void standard_mouse_msg(void)
{
  if (key_state.shift) {
    if (key_state.control)
      mouse_msg("", "", "sl more type");
    else
      mouse_msg("scale", "pan", "select more");
  } else {
    if (key_state.control)
      mouse_msg("stretch", "rotate", "select type");
    else
      mouse_msg(curobj->button(), "move", "select");
  }
}

advertise void fill_mouse_explainer(Widget frame)
{
  Widget form =
    XtVaCreateManagedWidget("mouseForm",
			    xmFormWidgetClass, frame,
			    NIL);
  middleMouse  =
    XtVaCreateManagedWidget("mouseLabel",
			    xmLabelWidgetClass, form,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNtopAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNalignment, XmALIGNMENT_CENTER,
			    NIL);

  unsigned long fpix, bpix;
  XtVaGetValues(middleMouse,
		XmNbackground, &bpix,
		XmNforeground, &fpix,
		NIL);
  
  Pixmap mousePix =
    XCreatePixmapFromBitmapData(display,
				DefaultRootWindow(display),
				mouse_bits, mouse_width, mouse_height,
				fpix, bpix,
				DefaultDepth(display, screen_num));
  
  leftMouse  =
    XtVaCreateManagedWidget("mouseLabel",
			    xmLabelWidgetClass, form,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, middleMouse,
			    XmNrightAttachment, XmATTACH_NONE,
			    XmNalignment, XmALIGNMENT_END,
			    NULL);

  Widget mouseIcon =
    XtVaCreateManagedWidget("mouseIcon",
			    xmLabelWidgetClass, form,
			    XmNlabelPixmap, mousePix,
			    XmNleftAttachment, XmATTACH_WIDGET,
			    XmNleftWidget, leftMouse,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, middleMouse,
			    XmNrightAttachment, XmATTACH_NONE,
			    XmNalignment, XmALIGNMENT_END,
			    NIL);

  rightMouse  =
    XtVaCreateManagedWidget("mouseLabel",
			    xmLabelWidgetClass, form,
			    XmNleftAttachment, XmATTACH_WIDGET,
			    XmNleftWidget, mouseIcon,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, middleMouse,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNalignment, XmALIGNMENT_BEGINNING,
			    NIL);
}
