/*
 * property.C
 * 
 * The property display and editor
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>

#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>

static Widget propertyWindow;
static Widget browser;

static char *propname;

//
//----------------------------------------------------------------------
//
// POPUP and POPDOWN window
//

advertise void show_property_window(char *fname)
{
  propname = fname;
  
  // load file
  ipestream fh;
  if (!fh.open(propname, "r")) {
    show_message("cannot open property file for reading", propname);
    return;
  }
  struct stat statbuf;
  
  if (stat(propname, &statbuf)) {
    show_message("cannot stat property file", propname);
    return;
  }
  unsigned int length = (unsigned int) statbuf.st_size;
  char *file_string = new char [length + 1];

  fh.read(file_string, 1, length);
  fh.close();

  file_string[length] = '\0';
  XmTextSetString(browser, file_string);
  delete [] file_string;
  
  // show window
  XtManageChild(propertyWindow);
}

static void hide_cb(Widget, XtPointer, XtPointer)
{
  XtUnmanageChild(propertyWindow);
}

static void edited_cb(Widget, XtPointer, XtPointer)
{
  // save browser in file
  ipestream ofh;
  if (!ofh.open(propname, "w")) {
    show_message("Cannot open file for writing", propname);
    return;
  }
  char *browser_string = XmTextGetString(browser);
  ofh << browser_string;
  XtFree(browser_string);
  ofh.close();
  if (!ofh.good()) {
    show_message("ERROR while writing properties file", propname);
    return;
  }

  // now try to load file
  ipestream fh;
  if (!fh.open(propname, "r")) {
    show_message("cannot open file for reading", propname);
    return;
  }
  ps_okay = TRUE;
  Group *gr = new Group(fh);
  fh.close();
  if (!ps_okay) {
    show_message("could not read property file", propname);
    delete gr;
    return;
  }
  // gr->first is the object to replace selection
  Iobject *ob = gr->first->copy();
  delete gr;

  clear_selection();
  pic->add_object(ob);
  object_added();
  redraw_canvas();

  // remove property window
  XtUnmanageChild(propertyWindow);
}

static void update_cb(Widget, XtPointer, XtPointer)
{
  struc_function(STRUC_PROPERTIES);
}

//
//----------------------------------------------------------------------
//
// CREATE window
//

advertise void create_property_window(void)
{
  propertyWindow =
    XmCreateFormDialog(topLevel, "propertyWindow", NIL, 0);

  Widget editedButton = 
    XtVaCreateManagedWidget("editedButton",
			    xmPushButtonWidgetClass, propertyWindow,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NIL);
  XtAddCallback(editedButton, XmNactivateCallback, edited_cb, NIL);
  
  Widget updateButton = 
    XtVaCreateManagedWidget("updateButton",
			    xmPushButtonWidgetClass, propertyWindow,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NIL);
  XtAddCallback(updateButton, XmNactivateCallback, update_cb, NIL);
  
  Widget hideButton = 
    XtVaCreateManagedWidget("hideButton",
			    xmPushButtonWidgetClass, propertyWindow,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NIL);
  XtAddCallback(hideButton, XmNactivateCallback, hide_cb, NIL);

  Arg arg[10];
  int ac = 0;
  XtSetArg(arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(arg[ac], XmNbottomWidget, updateButton); ac++;
  XtSetArg(arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  
  browser =
    XmCreateScrolledText(propertyWindow, "propertyBrowser", arg, ac);
  XtManageChild(browser);
}

