/*
 * resources.C
 * 
 * read Ipe's resources from AppDefaults file, Users' resources,
 *  and command line
 *
 * $Modified: Monday, September 19, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ipe.h"
#include <X11/StringDefs.h>

#define XtNdebug		"debug"
#define XtCDebug		"Debug"
#define XtNmakeBackups		"makeBackups"
#define XtCMakeBackups		"MakeBackups"
#define XtNdeltaAlpha		"deltaAlpha"
#define XtCListIndex		"ListIndex"
#define XtNlineStyle		"lineStyle"
#define XtNlineWidth		"lineWidth"
#define XtNarrowType		"arrowType"
#define XtCArrowType		"ArrowType"
#define XtNipeFont		"ipeFont"
#define XtNmipeFont		"mipeFont"
#define XtNipeFontsize		"ipeFontsize"
#define XtNmipeFontsize		"mipeFontsize"
#define XtNstrokeColor		"strokeColor"
#define XtNfillColor		"fillColor"
#define XtCColorIndex		"ColorIndex"
#define XtNcircleVariant	"circleVariant"
#define XtNarcVariant		"arcVariant"
#define XtNmarkVariant		"markVariant"
#define XtCInputVariant		"InputVariant"
#define XtNgridSize		"gridSize"
#define XtNipeArrowSize		"ipeArrowSize"
#define XtNmipeArrowSize	"mipeArrowSize"
#define XtCArrowSize		"ArrowSize"
#define XtNipeMarkSize		"ipeMarkSize"
#define XtNmipeMarkSize		"mipeMarkSize"
#define XtCMarkSize		"MarkSize"
#define XtNsnapSelf		"snapSelf"
#define XtCSnapSelf		"SnapSelf"
#define XtNenableUndo		"enableUndo"
#define XtNenableLatexBox	"enableLatexBox"
#define XtNenableFifi		"enableFifi"
#define XtNenableInterior	"enableInterior"
#define XtNenableZoomPan	"enableZoomPan"
#define XtNenableStroke		"enableStroke"
#define XtNenable3Spline	"enable3Spline"
#define XtCEnableButton		"EnableButton"
#define XtNselectDistance	"selectDistance"
#define XtNsnapDistance		"snapDistance"
#define XtCScreenDistance	"ScreenDistance"
#define XtNgridVisible		"gridVisible"
#define XtCGridVisible		"GridVisible"
#define XtNshowShortcuts	"showShortcuts"
#define XtCShowShortcuts	"ShowShortcuts"
#define XtNsplinePrecision	"splinePrecision"
#define XtNundoLimit		"undoLimit"
#define XtCUndoLimit		"UndoLimit"
#define XtNhelpCommand		"helpCommand"
#define XtNfontScale		"fontScale"
#define XtNeditFontScale	"editFontScale"
#define XtCFontScale		"FontScale"

#define RESOURCE_COLOR(name, entry) { \
  name, XtCColor, XmRString, sizeof(XColor), XtOffsetOf(AppData, entry),\
  XmRString, "black" }				      

#define RESOURCE_BOOLEAN(name, cls, entry, value) { \
  name, cls, XmRBoolean, sizeof(Boolean), XtOffsetOf(AppData, entry),\
  XmRImmediate, XtPointer(value) }

#define RESOURCE_STRING(name, entry, value) { \
  name, XmCString, XmRString, sizeof(char *), XtOffsetOf(AppData, entry),\
  XmRImmediate, value }

#define RESOURCE_FLOAT(name, cls, entry, value) { \
  name, cls, XtRFloat, sizeof(float), XtOffsetOf(AppData, entry),\
  XmRString, value }

#define RESOURCE_INT(name, cls, entry, value) { \
  name, cls, XmRInt, sizeof(int), XtOffsetOf(AppData, entry),\
  XmRImmediate, XtPointer(value) }

advertise XtAppContext app_context;

advertise AppData app;

//
// Description of Ipe's resources
//

static XtResource resources[] =
{
  RESOURCE_INT(XtNdebug, XtCDebug, debug, 0),
  RESOURCE_BOOLEAN(XtNmakeBackups, XtCMakeBackups, make_backups, TRUE),
  RESOURCE_BOOLEAN("mipeMode", "MipeMode", mipe_mode, FALSE),
  RESOURCE_BOOLEAN("monochrome", "Monochrome", monochrome, FALSE),
  RESOURCE_BOOLEAN("privateColors", "PrivateColors", private_colors, TRUE),
  {
    XtNdeltaAlpha,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, delta_alpha_choice),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNlineStyle,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, linestyle_choice),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNlineWidth,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, line_width_choice),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNarrowType,
    XtCArrowType,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, arrow_type),
    XmRImmediate,
    XtPointer(0)
  },
  {
    XtNipeFont,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, font_choice),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNmipeFont,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, font_choice) + sizeof(int),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNipeFontsize,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, fontsize_choice),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNmipeFontsize,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, fontsize_choice) + sizeof(int),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNstrokeColor,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, current_color),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNfillColor,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, current_color) + sizeof(int),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNcircleVariant,
    XtCInputVariant,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, circle_variant),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNarcVariant,
    XtCInputVariant,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, arc_variant),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNmarkVariant,
    XtCInputVariant,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, mark_variant),
    XmRImmediate,
    XtPointer(1)
  },
  {
    XtNgridSize,
    XtCListIndex,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, grid_size_choice),
    XmRImmediate,
    XtPointer(1)
  },
  RESOURCE_FLOAT(XtNipeArrowSize, XtCArrowSize, arrow_size[0], "7.0"),
  RESOURCE_FLOAT(XtNmipeArrowSize, XtCArrowSize, arrow_size[1], "14.0"),
  RESOURCE_FLOAT(XtNipeMarkSize, XtCMarkSize, mark_size[0], "2.0"),
  RESOURCE_FLOAT(XtNmipeMarkSize, XtCMarkSize, mark_size[1], "3.5"),
  {
    XtNsnapSelf,
    XtCSnapSelf,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, snap_self),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableUndo,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_undo),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableLatexBox,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_latex_box),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableFifi,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_fifi),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableInterior,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_interior),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableZoomPan,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_zoom_pan),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenableStroke,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_stroke),
    XmRImmediate,
    XtPointer(TRUE)
  },
  {
    XtNenable3Spline,
    XtCEnableButton,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, enable_3_spline),
    XmRImmediate,
    XtPointer(TRUE)
  },
  RESOURCE_FLOAT(XtNselectDistance, XtCScreenDistance,
		 select_distance, "10.0"),
  RESOURCE_FLOAT(XtNsnapDistance, XtCScreenDistance, snap_distance, "6.0"),
  {
    XtNgridVisible,
    XtCGridVisible,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, grid_visible),
    XmRImmediate,
    XtPointer(FALSE)
  },
  {
    XtNshowShortcuts,
    XtCShowShortcuts,
    XmRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, show_shortcuts),
    XmRImmediate,
    XtPointer(TRUE)
  },
  RESOURCE_FLOAT(XtNsplinePrecision, XtCScreenDistance,
		 spline_precision, "1.0"),
  {
    XtNundoLimit,
    XtCUndoLimit,
    XmRInt,
    sizeof(int),
    XtOffsetOf(AppData, undo_limit),
    XmRImmediate,
    XtPointer(200)
  },
  RESOURCE_COLOR("color1", color[1]),
  RESOURCE_COLOR("color2", color[2]),
  RESOURCE_COLOR("color3", color[3]),
  RESOURCE_COLOR("color4", color[4]),
  RESOURCE_COLOR("color5", color[5]),
  RESOURCE_COLOR("color6", color[6]),
  RESOURCE_COLOR("color7", color[7]),
  RESOURCE_COLOR("color8", color[8]),
  RESOURCE_COLOR("color9", color[9]),
  RESOURCE_COLOR("color10", color[10]),
  RESOURCE_COLOR("color11", color[11]),
  RESOURCE_COLOR("color12", color[12]),
  RESOURCE_COLOR("color13", color[13]),
  RESOURCE_COLOR("color14", color[14]),
  RESOURCE_COLOR("selectionColor", 	sys_color[0]),
  RESOURCE_COLOR("creationColor",	sys_color[1]),
  RESOURCE_COLOR("editColor",		sys_color[2]),
  RESOURCE_COLOR("moveColor",		sys_color[3]),
  RESOURCE_COLOR("panColor",		sys_color[4]),
  RESOURCE_COLOR("dragColor",		sys_color[5]),
  RESOURCE_COLOR("axisColor",		sys_color[6]),
  RESOURCE_COLOR("gridColor",		sys_color[7]),
  RESOURCE_COLOR("canvasBackground",	sys_color[8]),
  RESOURCE_FLOAT(XtNfontScale, XtCFontScale, font_scale, "1.0"),
  RESOURCE_FLOAT(XtNeditFontScale, XtCFontScale, edit_font_scale, "1.0"),
  RESOURCE_STRING("ghostscriptName", ghostscript_name, "/usr/local/bin/gs" ),
  RESOURCE_STRING("latexCommand", latex_command, "latex" ),
  RESOURCE_STRING("printCommand", print_command, "" ),
  RESOURCE_STRING("helpCommand",  help_command, ""),
  RESOURCE_STRING("dvipsCommand", dvips_command, 
		  "dvips -o %s ipe_pages.dvi" ),
  RESOURCE_STRING("tmpDirectory", tmp_directory, "/usr/tmp" ),
  RESOURCE_STRING("iumDirectories", ium_directories, "" ),
  RESOURCE_STRING("psPreamble", ps_preamble, "" ),
  RESOURCE_STRING("ipePreviewCommand", preview_command[0], "" ),
  RESOURCE_STRING("mipePreviewCommand", preview_command[1], "" ),
  RESOURCE_STRING("ipePreamble", latex_preamble[0], "" ),
  RESOURCE_STRING("mipePreamble", latex_preamble[1], "" ),
  
  RESOURCE_STRING("romanFontGL",  font_name_gl[0], "Times-Roman" ),
  RESOURCE_STRING("italicFontGL", font_name_gl[1], "Times-Italic" ),
  RESOURCE_STRING("boldFontGL",   font_name_gl[2], "Times-Bold" ),
  RESOURCE_STRING("mathFontGL",   font_name_gl[3], "Helvetica-Oblique" ),
  RESOURCE_STRING("romanEditFontGL",  font_name_gl[4], "Times-Roman" ),
  RESOURCE_STRING("italicEditFontGL", font_name_gl[5], "Times-Italic" ),
  RESOURCE_STRING("boldEditFontGL",   font_name_gl[6], "Times-Bold" ),
  RESOURCE_STRING("mathEditFontGL",   font_name_gl[7], "Helvetica-Oblique" ),

  RESOURCE_STRING("romanFontX",      font_name_x[0],
		  "*-times-medium-r-normal-*" ),
  RESOURCE_STRING("italicFontX",     font_name_x[1],
		  "*-times-medium-i-normal-*" ),
  RESOURCE_STRING("boldFontX",       font_name_x[2], 
		  "*-times-bold-r-normal-*" ),
  RESOURCE_STRING("mathFontX",       font_name_x[3], 
		  "*-helvetica-medium-r-normal-*" ),
  RESOURCE_STRING("romanEditFontX",  font_name_x[4], 
		  "*-times-medium-r-normal-*" ),
  RESOURCE_STRING("italicEditFontX", font_name_x[5], 
		  "*-times-medium-i-normal-*" ),
  RESOURCE_STRING("boldEditFontX",   font_name_x[6], 
		  "*-times-bold-r-normal-*" ),
  RESOURCE_STRING("mathEditFontX",   font_name_x[7], 
		  "*-helvetica-medium-r-normal-*" ),

  RESOURCE_STRING("linestyleList",    linestyle_list,  "1111 0fff 5555"),
  RESOURCE_STRING("lineWidthList",    line_width_list, "0.4 1.2 2.0"),
  RESOURCE_STRING("gridSizeList",     grid_size_list,  "4 8 12 16 24"),
  RESOURCE_STRING("deltaAlphaList",   delta_alpha_list, "45 60 90"),
  RESOURCE_STRING("ipeFontsizes",     fontsize_list[0], "10 11 12"),
  RESOURCE_STRING("mipeFontsizes",    fontsize_list[1], "12 14.4"),
  RESOURCE_STRING("ipeSystemMacros",  iums, ""),
  RESOURCE_STRING("ipeUserMacros",    more_iums, ""),
};

//
// Command-line options table
//

static XrmOptionDescRec options[] = {
  {"-debug",    "*debug",           XrmoptionSepArg, NIL },
  {"-monochrome", "*monochrome",    XrmoptionNoArg,  "True"},
  {"-shared",	"*privateColors",   XrmoptionNoArg,  "False"},
  {"-private",	"*privateColors",   XrmoptionNoArg,  "True"},
  {"-i",        "*mipeMode",        XrmoptionNoArg,  "False"},
  {"-m",        "*mipeMode",        XrmoptionNoArg,  "True" },
};

static void Syntax(int argc, char **argv)
{
  cerr << "Ipe: command line option not understood:\n";

  // last argument could be file name - skip that
  if (argv[argc - 1][0] != '-')
    argc--;
  
  // first argument is program name - skip that
  for (int i = 1; i < argc; i++) {
    cerr << "option: " << argv[i] << "\n";
  }
  
  cerr << "Ipe understands all standard Xt command line options.\n";
  
  cerr << "Additional options are as follows:\n"
       << "Option\n"
       << "-i           sets Ipe in single page (Ipe) mode\n"
       << "-m           sets Ipe in multi page (Mipe) mode\n"
       << "[file]       starts up with drawing in file\n";

  exit(9);
}

//
//----------------------------------------------------------------------
//
// decode STRINGS into LISTS of s_coords or linestyles
//

static void decode_linestyle(void)
{
  linestyle_list.newsize(0);
  def_linestyle(0xffff, "solid");

  unsigned long ls;
  char *p = app.linestyle_list;
  char *q;
  
  while (*p) {
    ls = strtol(q = p, &p, 16);
    if (p == q) {
      cerr << "Cannot parse linestyle description:\n"
	   << app.linestyle_list << "\n";
      return;
    }
    def_linestyle(short(ls), NIL);
  }
}

static void decode_scoord_list(char *str, s_coordreray &list)
// convert string to a list of s_coords
{
  s_coord val;
  char *p = str;
  char *q;
  
  list.newsize(0);
  while (*p) {
    val = strtod(q = p, &p);
    if (p == q) {
      cerr << "Cannot convert string to a list of s_coords:\n" << str << "\n";
      return;
    }
    list.append(val);
  }
}

static void decode_ium_directories(void)
{
  ium_directory.newsize(0);
  char *p = app.ium_directories;
  Boolean cont = (*p != '\0');
  while (cont) {
    ium_directory.append(p);
    while (*p && *p != ':')
      p++;
    cont = (*p != '\0');
    *p++ = '\0';
    DEBUG(DBG_PARM, "Ium Directory found: ",
	  ium_directory[ium_directory.size() - 1]);
  }
}

//
//----------------------------------------------------------------------
//
// OPTIONS and RESOURCES
//

advertise char *load_options_and_resources(int *pargc, char **argv)
{
  char *firstfile = NIL;

  topLevel =
    XtVaAppInitialize(&app_context,       /* Application context */
		      "Ipe", 
		      options, XtNumber(options),
#if ((XmVersion > 1001) || defined(__alpha))
		      pargc, argv,
#else
		      ((Cardinal *) pargc), argv,
#endif
		      NIL,               /* for missing app-defaults file */
		      NIL);              /* terminate varargs list */
  
  // XtInitialize leaves program name in args
  if (*pargc > 2 || (*pargc == 2 && argv[1][0] == '-'))
    Syntax(*pargc, argv);
  
  XtGetApplicationResources(topLevel, 
			    (XtPointer) &app, 
			    resources, 
			    XtNumber(resources), 
			    NULL, 
			    0);
  
  //
  // FORMS
  //
  // We must check the application resource values here.
  // Otherwise, user could supply out of range values and crash program.
  // Conversion routines do this automatically, so colors are already checked.
  //

  monochrome = app.monochrome;
  mipe_mode = app.mipe_mode;
  
  delta_alpha_choice = app.delta_alpha_choice - 1;
  linestyle_choice = app.linestyle_choice - 1;
  line_width_choice = app.line_width_choice - 1; 
  arrow_type = app.arrow_type;
  grid_size_choice = app.grid_size_choice - 1;

  grid_visible = app.grid_visible;

  mark_variant = app.mark_variant - 1;
  arc_variant = app.arc_variant - 1;
  circle_variant = app.circle_variant - 1;
  
  for (int i = 0; i < 2; i++) {
    font_choice[i] = app.font_choice[i] - 1;
    fontsize_choice[i] = app.fontsize_choice[i] - 1;
    current_color[i] = app.current_color[i];
    arrow_size[i] = app.arrow_size[i];
    mark_size[i] = app.mark_size[i];
  }

  select_distance = app.select_distance;
  snap_distance = app.snap_distance;
  
  //
  // now we have to decode the lists
  //
  decode_linestyle();

  DEBUG(DBG_PARM, "Parameter font_scale = ", app.font_scale);
  DEBUG(DBG_PARM, "Parameter edit_font_scale = ", app.edit_font_scale);

  decode_scoord_list(app.line_width_list,  line_width_list);
  decode_scoord_list(app.grid_size_list,   grid_size_list);
  decode_scoord_list(app.delta_alpha_list, delta_alpha_list);
  decode_scoord_list(app.fontsize_list[0], fontsize_list[0]);
  decode_scoord_list(app.fontsize_list[1], fontsize_list[1]);

  decode_ium_directories();
  
  if (*pargc == 2)
    firstfile = argv[1];
  return firstfile;
}
