/*
 * gridalign.c
 * 
 * Ipe User Macros for aligning objects to the grid
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "ium.h"

void align_to_grid(int moveall)
{
  IpeObject *ob;
  double grid, mx, my;
  vertex v;
  int i, ignore;

  grid = ipe_environment.gridsize;
  
  for (ob = ium_input; ob; ob = ob->next) {
    ignore = 0;

    switch (ob->type) {
    case IPE_LINE:
    case IPE_SPLINE:
      v = ob->w.line->v[0];
      break;
    case IPE_CIRCLE:
      v = ob->w.circle->center;
      break;
    case IPE_ARC:
      v = ob->w.arc->center;
      break;
    case IPE_MARK:
      v = ob->w.mark->pos;
      break;
    case IPE_TEXT:
      v = ob->w.text->pos;
      break;
    case IPE_BITMAP:
      v = ob->w.bitmap->ll;
      break;
    case IPE_BEGINGROUP:
    case IPE_ENDGROUP:
      ignore = 1;
      break;
    }

    if (!ignore) {
      mx = grid * floor(v.x/grid + 0.5);
      my = grid * floor(v.y/grid + 0.5);
      v.x = mx;
      v.y = my;
      
      switch (ob->type) {
      case IPE_LINE:
      case IPE_SPLINE:
	if (moveall) {
	  for (i = 0; i < ob->w.line->n; i++) {
	    mx = grid * floor(ob->w.line->v[i].x/grid + 0.5);
	    my = grid * floor(ob->w.line->v[i].y/grid + 0.5);
	    ob->w.line->v[i].x = mx;
	    ob->w.line->v[i].y = my;
	  }
	} else {
	  mx -= ob->w.line->v[0].x;
	  my -= ob->w.line->v[0].y;
	  for (i = 0; i < ob->w.line->n; i++) {
	    ob->w.line->v[i].x += mx;
	    ob->w.line->v[i].y += my;
	  }
	}
	break;
      case IPE_CIRCLE:
	ob->w.circle->center = v;
	break;
      case IPE_ARC:
	ob->w.arc->center = v;
	break;
      case IPE_MARK:
	ob->w.mark->pos = v;
	break;
      case IPE_TEXT:
	ob->w.text->pos = v;
	break;
      case IPE_BITMAP:
	ob->w.bitmap->ll = v;
	break;
      }
    }
  }
  ium_output = ium_input;
}

void main(int argc, char **argv)
{
  ium_begin(argc, argv);
  
  align_to_grid( atoi(ium_argument) );

  ium_mode = IUM_REPLACE;
  ium_end();
}
