/*
 * ium.h
 * 
 * This is the header file for Ipe User Macros
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef IUM_PLAGEO
#include <plageo.h>
#ifdef IUM_TRANSFORM
#include "transform.h"
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Ipe Object Types */

#define IPE_LINE       0
#define IPE_TEXT       1
#define IPE_CIRCLE     2
#define IPE_MARK       3
#define IPE_ARC        4
#define IPE_BITMAP     5
#define IPE_SPLINE     6
#define IPE_BEGINGROUP 7
#define IPE_ENDGROUP   8

/* Ipe Color Type
   the empty color has entry -1 for red */

typedef struct _IpeColor {
  float red, green, blue;
} IpeColor;

/* Ipe Font Type */

#define IPE_ROMAN   0
#define IPE_ITALIC  1
#define IPE_BOLD    2
#define IPE_MATH    3

typedef int bool;
#ifdef IUM_PLAGEO
typedef pl_vec vertex;
#else
typedef struct { float x, y; } vertex;
#endif

/* the Environment where the IUM is called */

typedef struct _IpeEnvironment {
  IpeColor stroke, fill;	/* current stroke and fill colors  */
  unsigned short linestyle;     /* solid, dashed etc. as 16 bits   */
  float linewidth;		/* linewidth of stroke             */
  short arrow;			/* two bits for two arrows         */
  float arsize;                 /* size of arrows                  */
  float marksize;               /* size of marks                   */
  float gridsize;               /* grid size                       */
  float snapangle;              /* snap angle                      */
  short marktype;               /* type of mark (1 .. 5)           */
  short font;                   /* font of text object             */
  float fontsize;               /* fontsize                        */
  bool  axisset;                /* is an axis system defined ?     */
  vertex origin;                /* if so, this is the origin       */
  float axisdir;                /*    and this the base direction  */
} IpeEnvironment;

typedef struct _Line {		/* also used for splines	   */
  bool closed;		        /* true if closed curve (polygon)  */
  short arrow;			/* two bits for two arrows         */
  float arsize;                 /* size of arrows                  */
#ifdef IUM_PLAGEO
  pl_vecreray v;                /* vertices of polyline            */
#else
  int n;                        /* number of vertices              */
  vertex *v;                    /* pointer to array of vertices    */
#endif
} Line;

typedef struct _Circle {
#ifdef IUM_TRANSFORM
  Transform tfm;                /* description of ellipse as affine
				   transformation of unit circle   */
#else
  vertex center;                /* center of circle                */
  float radius;                 /* radius of circle                */
  bool  ellipse;                /* is object an ellipse ?          */
  float tfm[4];                 /* tfm values from file            */
#endif
} Circle;

typedef struct _Mark {
  vertex pos;                   /* position                        */
  short type;                   /* type of mark (1 .. 5)           */
  float size;                   /* size of mark                    */
} Mark;

typedef struct _Arc {
  short arrow;			/* two bits for two arrows         */
  float arsize;                 /* size of arrows                  */
#ifdef IUM_PLAGEO
  pl_arc arc;                   /* center, radius, two angles      */
#else
  vertex center;                /* center of arc                   */
  float radius;                 /* radius of arc                   */
  float begangle, endangle;     /* two angles in radians           */
#endif
} Arc;

typedef struct _Text {
  char *str;                    /* the string                      */
  short font;                   /* font                            */
  float fontsize;               /* LaTeX fontsize                  */
  vertex pos;                   /* position of text                */
  bool minipage;                /* true if text is minipage        */
  vertex ll, ur;                /* ll and ur vertex of bounding box*/
} Text;

typedef struct _Bitmap {
  vertex ll, ur;      		/* lower left, upper right corner  */
  short width, height;          /* no of bits in bitmap            */
  unsigned long *words;         /* pointer to width*height pixels  */
  bool in_color;                /* color bitmap ?                  */
} Bitmap;

typedef struct _IpeObject {
  int type;                     /* type of this object             */
  bool primary;                 /* true if this is the primary sel.*/
  IpeColor stroke, fill;        /* stroke and fill color of object */
  unsigned short linestyle;	/* solid, dashed etc. as 16 bits   */
  float linewidth;		/* linewidth of stroke             */
  struct _IpeObject *next;      /* pointer to next object          */

  union W {
    Line   *line;
    Circle *circle;
    Mark   *mark;
    Text   *text;
    Arc    *arc;
    Bitmap *bitmap;
  } w ;

} IpeObject;

/* the current Ipe environment when IUM is called */

extern IpeEnvironment ipe_environment;

/* input and output for IUM */

extern IpeObject *ium_input;     /* selected objects from Ipe       */
extern char *ium_argument;       /* argument passed to Ium          */
extern char *ium_parameter;      /* parameter possibly passed       */

extern IpeObject *ium_output;    /* IUM generated things to Ipe     */
extern char *ium_message;        /* message to return to Ipe        */
extern int  ium_mode;


/*
 * ium_mode determines how Ipe should treat the output from the IUM:
 */

#define IUM_SELECT_OLD  0
#define IUM_SELECT_NEW  1
#define IUM_SELECT_BOTH 2
#define IUM_REPLACE     3
#define IUM_DELETE_OLD  4

/*
 *  these functions are used to start and end any IUM
 */

void ium_begin(int argc, char **argv);
void ium_init(int argc, char **argv);
void ium_end(void);

char *iumrc_get(char *);
void iumrc_put(char *, char *);

#ifdef __cplusplus
}
#endif
