#!/bin/csh -f
#
# Ipe user macro `postscript.ium'
#
# uses the Ghostscript interpreter to read in a Postscript file
# and to convert it into the format expected by Ipe.
#
# This file is part of the extendible drawing editor Ipe
# Copyright (C) 1994, 1995 Otfried Schwarzkopf
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#    
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#    
# A copy of the GNU General Public License is available on the World
# Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
# You can also obtain it by writing to the Free Software Foundation,
# Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

# illegal call (without file )
if ( $#argv < 3 ) exit 9;
#
set ipefile = $argv[1]
set psfile = $argv[3]

unset noclobber

#
# INSTALL: Name of ghostscript interpreter on next line
#
gs -dNODISPLAY -dWRITESYSTEMDICT -q - << _END_ > $ipefile
%
% A ghostscript prologue, that when run before a postscript program,
% will output an Ipe description of the postscript data
%
% it gives only a rough approximation of the original drawing:
%  * no different fonts are recognized
%  * no fontsizes are recognized
%  * all curves are approximated by polygonal chains
%  * linestyle etc are not recognized, but linewidth is
%

userdict begin
/IpeX 0 def
/IpeY 0 def
/IpeStr 30 string def
/IpeA 5000 array def
/IpeI 0 def
/IpeX 0 def
/IpeY 0 def
/IpeFill false def
/IpeWidth 1 def

/IpePrintXY { exch IpeStr cvs print ( ) print = } bind def

/IpePut {/IpeY exch store /IpeX exch store
  IpeA IpeI IpeX put IpeA IpeI 1 add IpeY put
  /IpeI dup load 2 add store} bind def

% closed-p -> IpePolygon ->

/IpePolygon {
  IpeFill { (% Line\n% cl\n% fic )} {(% Line\n% skc )} ifelse
  print currentrgbcolor 3 2 roll = exch = =
  (% ss 0 ) print IpeWidth =
  (% # ) print IpeI 2 div cvi =
  0 2 IpeI 2 sub {
    dup IpeA exch get exch 1 add IpeA exch get IpePrintXY
  } for
  { (% cl\n) print } if
  (% End\n) print
  /IpeI 0 store
} bind def

/IpeMoveTo {IpeI 2 gt {false IpePolygon} if /IpeI 0 store IpePut} bind def

/IpeLineTo {IpePut} bind def

/IpeCurveTo {pop pop pop pop pop pop} bind def

/IpeClosePath {true IpePolygon} bind def

/IpeConvertPath {
  /IpeFill exch store
  /IpeWidth currentlinewidth dup dtransform 
  gsave matrix defaultmatrix setmatrix idtransform add 2 div store
  flattenpath
  /IpeMoveTo load /IpeLineTo load /IpeCurveTo load /IpeClosePath load
  /IpeI 0 store pathforall
  IpeI 2 gt {false IpePolygon} if
  grestore newpath
} bind def

/IpeShow { gsave matrix defaultmatrix setmatrix currentpoint
  (% Text\n% xy ) print IpePrintXY
  (% skc ) print currentrgbcolor 3 2 roll = exch = =
  (% s ) print dup print (\n% End\n) print grestore } bind def
  
% systemdict is left writable

systemdict begin
/stroke { false IpeConvertPath } bind def
/fill { true IpeConvertPath } bind def
/eofill { true IpeConvertPath } bind def
/show { IpeShow show } bind def
/ashow { IpeShow ashow } bind def
/widthshow { IpeShow widthshow } bind def
/awidthshow { IpeShow awidthshow } bind def
/showpage {(\n% End\n% End\n) print} bind def
end

systemdict readonly pop

end  % userdict

% now do the job!

(%\\\\IUMid{5.0}\n) print
(% Interface 0 Included Postscript file\n% Group\n) print

($psfile) run

showpage

quit
_END_
#
# pass Ghostscript's exit status back to Ipe
#
exit $status
