/* -*-C++-*-
 *
 * transform.h
 * 
 * This describes the "Transform" class, which realizes a
 * planar affine transformation
 *
 * $Modified: Sunday, September 11, 1994 by otfried $
 *
 * This file is part of the extendible drawing editor Ipe
 * Copyright (C) 1994 Otfried Schwarzkopf
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *    
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *    
 * A copy of the GNU General Public License is available on the World
 * Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".

 * You can also obtain it by writing to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <plageo.h>

const s_coord SIMILAR_THRESHOLD = 0.01;

class Transform {
public:
  s_coord A[6];				// transformation matrix

  Transform(void);
  Transform(const s_coord *);
  void apply(pl_vec&);
  void lapply(pl_vec&);			// apply without translation
  pl_vec transl(void)			{ return pl_vec(A[4], A[5]); }
  void stretch(const s_coord, const s_coord);
  void transform(const pl_rotra&);
  Transform inverse(void);		// return inverse transformation
  int is_similar(void);  		// true if similar transform
  void premult(const Transform&);	// premultiply second matrix
};

