/*  -*-C++-*-
 *
 * imath.h
 *
 * This is a replacement for Plageo's "math++.h" header.
 * This one only calls ANSI functions, and has been
 * If your system's math library (-lm) contains single precision versions
 * certain math functions, namely sinf, cosf, acosf, atan2f, sqrtf,
 * fhypot, fabsf, floorf, ceilf, and powf, then you can define
 * SINGLE_PRECISION_ARITHMETIC. This will make things run slightly faster.
 *
 * $Modified: Friday, August 19, 1994 by otfried $
 */

#ifndef MATHPPH
#define MATHPPH 1

#include <math.h>
#include <float.h>

#ifdef sgi
// we set SINGLE_PRECISION_ARITHMETIC by default on an SGI
#define SINGLE_PRECISION_ARITHMETIC
#endif

#ifdef sun
// for some reason, sun doesn't have lrand48 although it exists in the man
#define lrand48 rand
#endif

inline float max_of_type(float)
{ return FLT_MAX; }

inline float min_of_type(float)
{ return -FLT_MAX; }

inline double max_of_type(double)
{ return DBL_MAX; }

inline double min_of_type(double)
{ return -DBL_MAX; }

inline double sin_pp(double x)
{ return sin(x); }

inline float sin_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return sinf(x);}
#else
{ return sin(x); }
#endif

inline double cos_pp(double x)
{ return cos(x);}

inline float cos_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return cosf(x);}
#else
{ return cos(x); }
#endif

inline double acos_pp(double x)
{ return acos(x); }

inline float acos_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return acosf(x);}
#else
{ return acos(x);}
#endif

inline double atan2_pp(double y, double x)
{ return atan2(y, x); }
  
inline float atan2_pp(float y, float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return atan2f(y, x);}
#else
{ return atan2(y, x);}
#endif

inline double sqrt_pp(double x)
{ return sqrt(x); }

inline float sqrt_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return sqrtf(x);}
#else
{ return sqrt(x);}
#endif

inline double hypot_pp(double x, double y)
{ return hypot(x, y); }
  
inline float hypot_pp(float x, float y)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return fhypot(x, y);}
#else
{ return hypot(x, y);}
#endif

inline double fabs_pp(double x)
{ return fabs(x); }

inline float fabs_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return fabsf(x); }
#else
{ return fabs(x); }
#endif

inline double floor_pp(double x)
{ return floor(x); }

inline float floor_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return floorf(x); }
#else
{ return floor(x); }
#endif

inline double ceil_pp(double x)
{ return ceil(x); }

inline float ceil_pp(float x)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return ceilf(x); }
#else
{ return ceil(x); }
#endif

inline double pow_pp(double x, double y)
{ return pow(x, y); }

inline float pow_pp(float x, float y)
#ifdef SINGLE_PRECISION_ARITHMETIC
{ return powf(x, y); }
#else
{ return pow(x, y); }
#endif

// 'rint' is not ANSI, so we use our own versions...
inline float rint_pp(float x)
{ return floor_pp(x + 0.5); }

inline double rint_pp(double x)
{ return floor(x + 0.5); }

#endif
