/*  -*-C++-*-
 *
 *  ipestream.h
 *
 *  This header file makes C++'s "<<" and ">>" operator use
 *  the <stdio.h> library instead of the C++ stream library.
 *  It seems that <stdio.h> is more portable than the latter,
 *  and this little file solved many portability problems for me.
 *
 * $Modified: Tue Dec 19 00:19:42 1995 by otfried $
 */

#ifndef IPESTREAM_H
#define IPESTREAM_H

#include <stdio.h>
#include <string.h>

class ipestream {
  FILE *_f;
public:
  ipestream(void)	{ _f = NULL; }
  ipestream(FILE *fd)	{ _f = fd; }
  
  int open(char *fname, char *mode) {
    _f = fopen(fname, mode); return (_f != NULL); }
  int openfd(int fd, char *mode) {
    _f = fdopen(fd, mode); return (_f != NULL); }
  void close(void) {
    fclose(_f); }
  void flush(void) {
    fflush(_f); }
  int good(void) {
    return (_f ? !(ferror(_f) || feof(_f)) : 0); }

  void write(const char *data, const int sz, const long nitems) {
    fwrite(data, sz, ((unsigned int) nitems), _f); }
  void read(char *data, const int sz, const long nitems) {
    fread(data, sz, ((unsigned int) nitems), _f); }
  
  ipestream & operator<< (const char *str) {
    fputs(str, _f); return *this; }
  ipestream & operator<< (const int n) {
    fprintf(_f, "%d", n); return *this; }
  ipestream & operator<< (const unsigned int n) {
    fprintf(_f, "%u", n); return *this; }
  ipestream & operator<< (const long int n) {
    fprintf(_f, "%ld", n); return *this; }
  ipestream & operator<< (const unsigned long int n) {
    fprintf(_f, "%lu", n); return *this; }
  ipestream & operator<< (const float f) {
    fprintf(_f, "%g", f); return *this; }
  ipestream & operator<< (const double f) {
    fprintf(_f, "%lg", f); return *this; }
  ipestream & operator<< (const char ch) {
    fputc(ch, _f); return *this; }

  void get(char &ch) {
    ch = char(fgetc(_f)); }
  char *getline(char *buf, int n) {
    char *str = fgets(buf, n, _f);
    if (str) {
      char *ep = str + strlen(str) - 1;
      if (*ep == '\n') *ep = '\0';
    }
    return str;
  }
  ipestream & operator>> (char *str) {
    fscanf(_f, "%s", str); return *this; }
  ipestream & operator>> (int &n) {
    fscanf(_f, "%d", &n); return *this; }
  ipestream & operator>> (long int &n) {
    fscanf(_f, "%ld", &n); return *this; }
  ipestream & operator>> (float &f) {
    fscanf(_f, "%g", &f); return *this; }
  ipestream & operator>> (double &f) {
    fscanf(_f, "%lg", &f); return *this; }
};

typedef ipestream ostream;
typedef ipestream istream;

static ipestream cerr(stderr);
static ipestream cin(stdin);
static ipestream cout(stdout);

#endif
