/*
 * ireray.C
 *
 * This implements Plageo's reray type,
 * but to avoid portability issues with templates,
 * we avoid templates altogether.
 *
 * To use this: #define reray_T to be the reray type, T to be the type,
 *              and #include this file
 *
 * This was generated by the following substitutions from "reray.c":
 *   template  -> // template
 *   reray<T>  -> reray_T
 *   reray(    -> reray_T(
 *   made MIN_GROW a #define
 *
 * $Modified: Monday, August 15, 1994 by otfried $
 */

#include <stdlib.h>
#include <math.h>

#define GROW_FAC 1.3
#define MIN_GROW 4
//const float GROW_FAC = 1.3;
//const int MIN_GROW = 4;

// template<class T>
reray_T::reray_T(unsigned int s)
{
    if (s==0) {
	reserved_size = sz = 0;
	v = 0;
    } else {
	reserved_size = sz = s;
	v = new T[s];
    }
}

// template<class T>
reray_T::reray_T(const reray_T & a)
{
    register i = a.sz;
    reserved_size = sz = i;
    if (i==0) {
	v = 0;
    } else {
	v = new T[i];
	if ( v == 0) {
	    cerr<<"Out of memory (reray allocation).\n";
	    abort();
	}
	register T *vv = &v[i];
	register T *av = &a.v[i];
	while (i--)
	    *--vv = *--av;
    }
}

// template<class T>
T reray_T::elem(unsigned int index) const
{
    if (index < 0 || index >= size()) {
	cerr<<"Out of bounds reray indexing.\nCore dumped.\n";
	abort();
    }
    return operator[](index);
}

// template<class T>
void reray_T::replace(unsigned int index, const T &s)
{
    if (index < 0 || index >= size()) {
	cerr<<"Out of bounds reray indexing.\nCore dumped.\n";
	abort();
    }
    (*this)[index] = s;
}

// template<class T>
void reray_T::resize(unsigned int nsize)
{
    if (nsize > reserved_size) {
	int i;
	T *new_reray;
	i = int(GROW_FAC*reserved_size);
	if (i < (reserved_size + MIN_GROW))
	    i = reserved_size + MIN_GROW;
	reserved_size = ( i > nsize) ? i : nsize;
	new_reray = new T[reserved_size];
	if (new_reray == 0) {
	    cerr<<"Out of memory (reray allocation).\n";
	    abort();
	}
	for (i=0; i<sz; i++)
	    new_reray[i] = v[i];
	if (v != 0)
	    delete [] v;
	v = new_reray;
    }
    sz = nsize;
}

// template<class T>
void reray_T::newsize(unsigned int nsize)
{
// reserve space for elements
// if this reray is too small to contain all elements
    if (nsize > reserved_size) {
	if (v != 0)
	    delete [] v;
	int i;
	i = int(GROW_FAC*reserved_size);
	if (i < (reserved_size + MIN_GROW))
	    i = reserved_size + MIN_GROW;
	reserved_size = ( i > nsize) ? i : nsize;
	v = new T[reserved_size];
	if ( v == 0) {
	    cerr<<"Out of memory (reray allocation).\n";
	    abort();
	}
    }
    sz = nsize;
}

// template<class T>
reray_T & reray_T::operator=(const reray_T & a)
{
    if (this == &a) // x=x;
	return *this;
    int i = int(a.sz);
    newsize(i);
// copy elements
    if (i == 0)
	return *this;
    register T *vv = &(v[i]);
    register T *av = &(a.v[i]);
    while (i--)
	*--vv = *--av;
    return *this;
}

// template<class T>
void reray_T::compactify() const
{
    int i;
    T* new_reray;
    if (reserved_size <= sz)
	return;
    if (sz == 0) {
	delete [] v;
	((reray_T *)this)->v = 0;
    } else {
	new_reray = new T[sz];
	if (new_reray == 0) {
	    cerr<<"Out of memory (reray allocation).\n";
	    abort();
	}
	for (i=0; i<sz; i++)
	    new_reray[i] = v[i];
	if (v != 0)
	    delete [] v;
	((reray_T *)this)->v = new_reray;	
    }
    ((reray_T *)this)->reserved_size = sz;
}

// template<class T>
void reray_T::swap_contents(reray_T &rr2)
{
    T *tv;
    int tsz, treserved_size;
    tv = v;
    tsz = sz;
    treserved_size = reserved_size;
    v = rr2.v;
    sz = rr2.sz;
    reserved_size = rr2.reserved_size;
    rr2.v = tv;
    rr2.sz = tsz;
    rr2.reserved_size = treserved_size;
}

typedef void *voidp;

/*
 * quicksort 
 * moet nog geoptimaliseerd worden: bij kleine ivsize overgaan op insertionsort oid
 * Dan geen swaps meer nodig,  maar direct in newv plaatsen.
 */
// template<class T>
void reray_T::sort(int (* compare)(const T &, const T &))
{
    int		    i, j;
    int             s, e, ivsize;
    int             sp = 0;
    int		    pivot;
    T*		    temp;
    T **	    pt;			// lijst met pointers, deze wordt gesorteerd.
					// 
    int             low[25], high[25];	// plek voor stack van sorteerintervallen
    
    if (sz <= 1)
	return;
// initialiseer eerst volgorde array
    pt = (T**) (new voidp[int(sz)]);	    // ????? should be new (T*) [sz]
    for (i = 0; i < sz; i++)
	pt[i] = v+i;
// zet eerste sorteerinterval op de stack
    low[sp] = 0;
    high[sp] = sz - 1;
    sp++;			// PUSH(0,this->sz-1);
    while (sp != 0) {
	sp--;
	s = low[sp];
	e = high[sp];		// POP(s,e);
	ivsize = e-s+1;
    // sorting of an interval >= 3 elements
	while (ivsize >= 3) {
	// take a random pivot
	    pivot = s + int(lrand48()%ivsize);
	    
	    
	    
	    
	// partition the array.
	// place keys smaller than pivot in front
	    i = s;
	    j = e;
	    while (i <= j) {
		while (i<=j && (i==pivot||compare(*pt[i], *pt[pivot])<= 0))
		    i++;
		while (j>=i && (j==pivot||compare(*pt[j], *pt[pivot]) >= 0))
		    j--;
		if (i < j) {
		    temp = pt[i];
		    pt[i] = pt[j];
		    pt[j] = temp;
		    i++;
		    j--;
		}
	    }
	// plaats de pivotwaarde op goede plek.	// ?????
	    if (pivot <= j) {
		if (pivot != j) {
		    temp = pt[pivot];
		    pt[pivot] = pt[j];
		    pt[j] = temp;
		}
		j--;
	    } else if (pivot >= i) {
		if (pivot != i) {
		    temp = pt[pivot];
		    pt[pivot] = pt[i];
		    pt[i] = temp;
		}
		i++;		
	    }
	// push het grootste deelinterval op de stack, ga de volgende
	// ronde verder met het kleinste interval.
	    if (e - i > j - s) {
		low[sp] = i;
		high[sp] = e;
		sp++;		// PUSH(i,e);
		e = j;
	    } else {
		low[sp] = s;
		high[sp] = j;
		sp++;		// PUSH(s,j);
		s = i;
	    }
	    ivsize = e-s+1;
	}
    // interval van grootte 2 sorteren
	if (ivsize == 2 && compare(*pt[s], *pt[e]) > 0 ) {
	    temp = pt[s];
	    pt[s] = pt[e];
	    pt[e] = temp;
	}
    }
// nu goedzetten van elementen
    reserved_size = sz;
    T* newv;
    newv = new T[sz];
    for (i=0; i<sz; i++)
	newv[i] = *pt[i];
    delete [] v;
    v = newv;
    delete [] pt;
}

// template<class T>
void reray_T::sort(int (* compare)(T, T))
{
    int		    i, j;
    int             s, e, ivsize;
    int             sp = 0;
    int		    pivot;
    T		    temp;
    int             low[25], high[25];	// plek voor stack van sorteerintervallen
    
    if (sz <= 1)
	return;
// zet eerste sorteerinterval op de stack
    low[sp] = 0;
    high[sp] = sz - 1;
    sp++;			// PUSH(0,this->sz-1);
    while (sp != 0) {
	sp--;
	s = low[sp];
	e = high[sp];		// POP(s,e);
	ivsize = e-s+1;
    // sorteren van interval >= 3 elementen
	while (ivsize >= 3) {
	// trek een random pivot
	    pivot = s + int(lrand48()%ivsize);
	    
	    
	    
	    
	// partitioneer nu het array.
	// plaats vooraan de keys kleiner dan pivot, achteraan de grotere.
	    i = s;
	    j = e;
	    while (i <= j) {
		while (i<=j && (i==pivot||compare(v[i], v[pivot])<=0))
		    i++;
		while (j>=i && (j==pivot||compare(v[j], v[pivot])>=0))
		    j--;
		if (i < j) {
		    temp = v[i];
		    v[i] = v[j];
		    v[j] = temp;
		    i++;
		    j--;
		}
	    }
	// plaats de pivotwaarde op goede plek.	// ?????
	    if (pivot <= j) {
		if (pivot != j) {
		    temp = v[pivot];
		    v[pivot] = v[j];
		    v[j] = temp;
		}
		j--;
	    } else if (pivot >= i) {
		if (pivot != i) {
		    temp = v[pivot];
		    v[pivot] = v[i];
		    v[i] = temp;
		}
		i++;		
	    }
	// push het grootste deelinterval op de stack, ga de volgende
	// ronde verder met het kleinste interval.
	    if (e - i > j - s) {
		low[sp] = i;
		high[sp] = e;
		sp++;		// PUSH(i,e);
		e = j;
	    } else {
		low[sp] = s;
		high[sp] = j;
		sp++;		// PUSH(s,j);
		s = i;
	    }
	    ivsize = e-s+1;
	}
    // interval van grootte 2 sorteren
	if (ivsize == 2 && compare(v[s], v[e]) > 0 ) {
	    temp = v[s];
	    v[s] = v[e];
	    v[e] = temp;
	}
    }
}

/*
// template<class T>
istream& operator>>(istream &is, reray_T &r)
{
    int i, sz;
    T t;
    is >> sz;
    if (!is)
	return is;
    if (sz < 0) {
	is.clear(ios::badbit|is.rdstate());
	return is;
    }
    r.newsize(sz);
    for (i=0; i<sz; i++) {
	is >> t;
	r[i] = t;
    }
    return is;
}

// template<class T>
ostream& operator<<(ostream &os, const reray_T &r)
{
    int i;
    os << r.size() << ' ';
    for (i=0; i<r.size(); i++) {
	os << '\n' << r[i];
    }
    return os;
}
*/
