/*
 * ireray.h
 *
 * This declares Plageo's reray type,
 * but to avoid portability issues with templates,
 * we avoid templates altogether.
 *
 * $Modified: Monday, September 19, 1994 by otfried $
 */

#ifndef IRERAYH
#define IRERAYH 1

#define DeclareReray(Trr, T)                                               \
  class  	Trr {							   \
  public: 							   	   \
    Trr()	{reserved_size = sz = 0; v = 0;}			   \
    Trr(const Trr&);							   \
    Trr(unsigned int s);						   \
    ~Trr() 	{ if (v != 0) delete [] v; }				   \
    Trr&	operator=(const Trr &);					   \
    unsigned	size() const { return sz; }				   \
    T		elem(unsigned int i) const;				   \
    T		&operator[](unsigned int index) const { return v[index]; } \
    T		&last() const	{ return v[sz-1]; }			   \
    void	newsize(unsigned int);			 		   \
    void	resize(unsigned int);			 		   \
    void	grow(int i)   { int nsz = sz+i; resize(nsz>0 ? nsz : 0); } \
    void	replace (unsigned int index, const T &s);		   \
    void	append(const T &s)	{ grow(1); last()=s;}		   \
    void	compactify() const;					   \
    void	sort(int (* compare)(const T &, const T&));		   \
    void	sort(int (* compare)(T, T));				   \
    void	swap_contents(Trr &) ;					   \
  protected:								   \
    T*			v;						   \
    unsigned int reserved_size;						   \
    unsigned int sz;							   \
}
#endif
