#include <math.h>
#include <plageo.h>


void intervals::toggle()
{
    starts_at_min_infinity = !starts_at_min_infinity;
}

void intervals::toggle_after(s_coord x)
{
    int i;
    int size = boundaries.size();
    boundaries.resize(size + 1);
    for (i=size-1; i >= 0 && boundaries[i] > x; i--)
	boundaries.replace(i+1, boundaries[i]);
    boundaries.replace(i+1, x);
}

int intervals::is_empty() const
{
    return (!starts_at_min_infinity) && boundaries.size()==0;
}

intervals operator&(const intervals &fiv0,
				const intervals &fiv1)
{
    intervals result;
    int covered0, covered1;
    int index0 = 0, index1 = 0;
    int size0 = fiv0.boundaries.size();
    int size1 = fiv1.boundaries.size();
    covered0 = fiv0.starts_at_min_infinity;
    covered1 = fiv1.starts_at_min_infinity;
    result.starts_at_min_infinity = covered0 && covered1;
    while (index0 < size0 && index1 < size1) {
	if (fiv0.boundaries[index0] < fiv1.boundaries[index1]) {
	    if (covered1)
		result.toggle_after(fiv0.boundaries[index0]);
	    covered0 = !covered0;
	    index0++;
	} else {
	    if (covered0)
		result.toggle_after(fiv1.boundaries[index1]);
	    covered1 = !covered1;
	    index1++;
	}
    }
    if (index0 == size0 && covered0)
	while (index1 < size1) {
	    result.toggle_after(fiv1.boundaries[index1]);
	    index1++;
	}
    if (index1 == size1 && covered1)
	while (index0 < size0) {
	    result.toggle_after(fiv0.boundaries[index0]);
	    index0++;
	}
    return result;
}

intervals operator|(const intervals &fiv0,
				const intervals &fiv1)
{
    intervals result;
    int covered0, covered1;
    int index0 = 0, index1 = 0;
    int size0 = fiv0.boundaries.size();
    int size1 = fiv1.boundaries.size();
    covered0 = fiv0.starts_at_min_infinity;
    covered1 = fiv1.starts_at_min_infinity;
    result.starts_at_min_infinity = covered0 || covered1;
    while (index0 < size0 && index1 < size1) {
	if (fiv0.boundaries[index0] < fiv1.boundaries[index1]) {
	    if (!covered1)
		result.toggle_after(fiv0.boundaries[index0]);
	    covered0 = !covered0;
	    index0++;
	} else {
	    if (!covered0)
		result.toggle_after(fiv1.boundaries[index1]);
	    covered1 = !covered1;
	    index1++;
	}
    }
    if (index0 == size0 && !covered0)
	while (index1 < size1) {
	    result.toggle_after(fiv1.boundaries[index1]);
	    index1++;
	}
    if (index1 == size1 && !covered1)
	while (index0 < size0) {
	    result.toggle_after(fiv0.boundaries[index0]);
	    index0++;
	}
    return result;
}

int intervals::find_index_after(s_coord x) const
{
    int min = 0;
    int max = boundaries.size()-1;
    if (max < 0 || x > boundaries[max])
	return max + 1;
    if (x <= boundaries[min])
	return min;
    // invariant: boundaries[min] < x <= boundaries[max]
    while (max - min > 1) {
	int mid;
	mid = (max + min) / 2;
	if ( x <= boundaries[mid])
	    max = mid;
	else
	    min = mid;
    }
    return max;
}

int intervals::is_interval_endpoint(int index) const
{
    if (starts_at_min_infinity)
	return !(index % 2);
    else
	return index % 2;
}

int intervals::lies_in(s_coord x) const
{
    int index;
    index = find_index_after(x);
    return is_interval_endpoint(index);
}

s_coord shortest_gap(const intervals &fiv0, const intervals &fiv1)
{
    int close, far;
    s_coord dclose, dfar;
    const intervals *fivs[2];
    fivs[0] = &fiv0;
    fivs[1] = &fiv1;
    int index[2];
    s_coord big;
    big = max_of_type(s_coord(0));
    s_coord bound = big;
    if (fiv0.starts_at_min_infinity) {
	if (fiv1.starts_at_min_infinity)
	    return 0;
	close = 0; far = 1;
	index[close] = 0; index[far] = 0;
	if (fivs[far]->boundaries.size() == 0)
	    return big;
	dfar = fivs[far]->boundaries[0];
    } else {
	if (fiv1.starts_at_min_infinity) {
	    close = 1; far = 0;
	    index[close] = 0; index[far] = 0;
	    if (fivs[far]->boundaries.size() == 0)
		return big;
	    dfar = fivs[far]->boundaries[0];
	} else  {
	    if (fiv0.boundaries.size() == 0 || fiv1.boundaries.size() == 0)
		return big;
	    index[close] = 1; index[far] = 0;
	    dclose = fiv0.boundaries[0];
	    dfar = fiv1.boundaries[0];
	    if (dclose <= dfar) {
		close = 0; far = 1;
	    } else {
		close = 1; far = 0;
		dfar = dclose;
	    }
	}
    }
    while (1) {
    // Check if current interval extends beyond far point.
	if (index[close] >= fivs[close]->boundaries.size())
	    return 0;
	dclose = fivs[close]->boundaries[index[close]];
	if (dclose > dfar)
	    return 0;
    // Check distance between this endpoint and far point.
    // Can be postponed.
	if ((dfar - dclose) < bound)
	    bound = dfar - dclose;
    // go to next interval
	index[close]++;
	if (index[close] >= fivs[close]->boundaries.size())
	    return bound;
	dclose = fivs[close]->boundaries[index[close]];
	if (dclose > dfar) {
	    // swap close and far
	    dfar = dclose;
	    close = 1 - close;
	    far = 1 - far;
	}
    // go to endpoint of this interval
	index[close]++;
    }
}

