// $Modified: Wednesday, August 17, 1994 by otfried $
#include <math.h>
#include <stdlib.h>
//#include <stdarg.h>
#include <plageo.h>

const s_coord scoord = 3;
static s_coord big = max_of_type(scoord);

pl_object_type pl_pgn::type() const
{
    return PL_POLYGON;
}

pl_box pl_pgn::bbox() const
{
    validate(bbflag);
    return _bb;
}

// make bounding box of a polygon
void pl_pgn::makebbox()
{
    _flags.set(bbflag);
    _bb.make_empty();
    if (size() < 1) {
	return;
    }
    _bb.add_first_point(vertex(0));
    for (int i=1; i<size(); i++) {
	_bb.add_non_first_point(vertex(i));
    }
}

// translate a polygon
void pl_pgn::translate(const pl_fixedvec & v)
{
    _bb.translate(v);
    for (int i = 0; i < size(); i++)
	_vertices[i] +=  v;
}

// transform a polygon
void pl_pgn::transform(const pl_transform & tfm)
{
    _flags.unset(bbflag);
    _flags.unset(sortflag);
    _flags.unset(directionflag);
    _el.newsize(0);
    _ord.newsize(0);
    _direction.newsize(0);
    for (int i = 0; i < size(); i++) {
	_vertices[i] = tfm * _vertices[i];
    }
}

// scale a polygon
void pl_pgn::scale(s_coord fac)
{
    int i, sz;
    sz = size();
    _flags.unset(areaflag);
    if (_flags.is_set(bbflag)) {
	pl_boundingbox newbb;
	newbb.add_first_point(pl_vec(fac * _bb.xmax(), fac * _bb.ymax()));
	newbb.add_non_first_point(pl_vec(fac * _bb.xmin(), fac * _bb.ymin()));
	_bb = newbb;
    }
    for (i = 0; i < sz; i++) {
	_vertices[i] *= fac;
    }
    if (fac <= 0) {
	_flags.unset(sortflag);
	_flags.unset(directionflag);
	_el.newsize(0);
	_ord.newsize(0);
	_direction.newsize(0);
    }
}

static int mymod(int i, int mod)
// mod must be positive
{
    // if (mod < 0) mod = -mod;
    int result;
    if (mod <= 1) {
	result = 0;
    } else {
	if (i < 0) {
	    result = -i % mod;
	    if (result != 0)
		result = mod-result;
	} else {
	    result = i % mod;
	}
    }
    return result;
}

const pl_vec & pl_pgn::vertex_mod(int i) const
{
    return vertex(mymod(i, size()));
}

pl_edge	pl_pgn::edge_mod(int i) const   // edge from vertex(i) to vertex(i+1)
{
    return edge(mymod(i, size()));
}

pl_edge pl_pgn::edge(int i) const
{
    if (i == size()-1)
	return pl_edge(_vertices[i], _vertices[0]);
    else
	return pl_edge(_vertices[i],_vertices[i+1]);
}

void pl_pgn::all_edges(pl_edgereray &result) const
{
    int i;
    result.newsize(size());
    for (i=0; i<size(); i++) {
	result[i] = edge(i);
    }
}

void pl_pgn::invert_orientation()
{
    int i, sz;
    pl_vec vt1, vt2;
    _flags.unset(sortflag);
    _flags.unset(directionflag);
    _el.newsize(0);
    _ord.newsize(0);
    _direction.newsize(0);
    _flags.toggle(is_clockwisef);
    sz = size()-1;
    for (i=0; 2*i < sz; i++) {
	vt1 = vertex(i);
	vt2 = vertex(sz-i);
	_vertices[i] = vt2;
	_vertices[sz-i] = vt1;
    }
}

void pl_pgn::compute_area()
{
    int i, maxn;
    s_coord t;
    _flags.set(areaflag);
    maxn = size()-1;
    if (maxn <2) {
	_area = 0;
	return;
    }
    t = vertex(maxn).y() * vertex(0).x() - vertex(0).y() * vertex(maxn).x();
    for (i=0; i<maxn; i++)
	t += vertex(i).y() * vertex(i+1).x() - vertex(i+1).y() * vertex(i).x();
    _area = fabs_pp(t/2);
}

void pl_pgn::compute_directions()
{
    int i;
    _flags.set(directionflag);
    _direction.newsize(size());
    for (i = 0; i < size(); i++)
	_direction[i] = edge(i).direction();
}

/*
 * the following alternative of sorting uses the generic sort routine.
 * It is simpler but slower, therefore not chosen.
pl_vecreray *sortvtcs;

int vertexcomp(unsigned short i, unsigned short j)
{
    return compare((*sortvtcs)[i], (*sortvtcs)[j]);
}

void pl_pgn::sort()
{
    int i;
    sortvtcs = &_vertices;
    _el.newsize(size());
    _ord.newsize(size());
// initialiseer eerst volgorde array
    for (i = 0; i < size(); i++)
	_el[i] = (unsigned short) i;
    _el.sort(vertexcomp);
    for (i = 0; i < size(); i++)
	_ord[_el[i]] = (unsigned short) i;
}
*/

/*
 * quicksort vertices of polygon. el[5]==3 means that there are exactly 5
 * vertices smaller than vertex(3) or, phrased otherwise, that the sixth(5+1)
 * element (counting from small to big vertices) is vertex 3. ord[7]==4 means
 * that there are 4 vertices smaller than vertex(7)
 */
 
void pl_pgn::sort()
{
    int             low[9], high[9];
// plek voor stack van sorteerintervallen
    int             sp = 0;
    unsigned short   t, pivindex;
    int             s, e, i, j;
    pl_vec         pivot;
    _flags.set(sortflag);
    _el.newsize(size());
    _ord.newsize(size());
// initialiseer eerst volgorde array
    for (i = 0; i < size(); i++)
	_el[i] = (unsigned short) i;
// zet eerste sorteerinterval op de stack
    low[sp] = 0;
    high[sp] = size() - 1;
    sp++;			// PUSH(0,this->size()-1);
    while (sp != 0) {
	sp--;
	s = low[sp];
	e = high[sp];		// POP(s,e);
    // sorteren van interval >= 3 elementen
	while (e - s >= 2) {
	// bepaal de volgorde van het eerste,tweede en laatste element.
	// swap de grootste waarde naar achteren.
	// gebruik de middelste waarde als pivot om te partitioneren.
	    if (vertex(_el[s]) < vertex(_el[e])) {
		if (vertex(_el[s + 1]) < vertex(_el[e])) {
		    if (vertex(_el[s]) < vertex(_el[s + 1]))
			pivindex = s + 1;
		    else
			pivindex = s;
		} else {
		    t = _el[e];
		    _el[e] = _el[s + 1];
		    _el[s+1] = t;
		    pivindex = s + 1;
		}
	    } else if (vertex(_el[s + 1]) < vertex(_el[e])) {
		t = _el[s];
		_el[s] = _el[e];
		_el[e] = t;
		pivindex = s;
	    } else if (vertex(_el[s]) > vertex(_el[s + 1])) {
		t = _el[s];
		_el[s] = _el[e];
		_el[e] = t;
		pivindex = s + 1;
	    } else {
		t = _el[s + 1];
		_el[s+1] = _el[e];
		_el[e] = t;
		pivindex = s;
	    }
	    pivot = vertex(_el[pivindex]);
	// partitioneer nu het array.
	// plaats vooraan de keys kleiner dan pivot, achteraan de grotere.
	    i = s + 2;
	    j = e - 1;
	    while (i <= j) {
		while (vertex(_el[i]) <= pivot && i<e)
		    i++;
		while (vertex(_el[j]) >= pivot && j>s)
		    j--;
		if (i < j) {
		    t = _el[i];
		    _el[i] = _el[j];
		    _el[j] = t;
		    i++;
		    j--;
		} else {
		    if (i==j) {
		    // this should not happen, but may happen if
		    // vertex[_el[i]] contains NaN.
		    cerr<<"Error detected by PlaGeo:\n"
			<<"  polygon contains invalid vertex "
			<<vertex(_el[i])<<".\n";
		    i++;
		    }
		}
	    }
	// plaats de pivotwaarde op goede plek.
	    if (j > pivindex) {
		t = _el[pivindex];
		_el[pivindex] = _el[j];
		_el[j] = t;
		j--;
	    }
	// push het grootste deelinterval op de stack, ga de volgende
	// ronde verder met het kleinste interval.
	    if (e - i > j - s) {
		low[sp] = i;
		high[sp] = e;
		sp++;		// PUSH(i,e);
		e = j;
	    } else {
		low[sp] = s;
		high[sp] = j;
		sp++;		// PUSH(s,j);
		s = i;
	    }
	}
    // interval van grootte 2 sorteren
	if (e - s == 1 && vertex(_el[s]) > vertex(_el[s + 1])) {
	    t = _el[s];
	    _el[s] = _el[e];
	    _el[e] = t;
	}
    }
// nu goedzetten van plaatsarray
    for (i = 0; i < size(); i++)
	_ord[_el[i]] = (unsigned short) i;
}


void pl_pgn::validate_work(short x) const
{
    // cast away const for changes to cache.
    if ( (x & bbflag) && !_flags.is_set(bbflag))
	((pl_pgn *) this)->makebbox();
    if ( (x & sortflag) && !_flags.is_set(sortflag))
	((pl_pgn *) this)->sort();
    if ( (x & simpleflag) && !_flags.is_set(simpleflag))
	((pl_pgn *) this)->check_simple();
    if ( (x & clockwiseflag) && !_flags.is_set(clockwiseflag))
	((pl_pgn *) this)->check_clockwise();
    if ( (x & convexflag) && !_flags.is_set(convexflag))
	((pl_pgn *) this)->check_convex();
    if ( (x & directionflag) && !_flags.is_set(directionflag))
	((pl_pgn *) this)->compute_directions();
    if ( (x & areaflag) && !_flags.is_set(areaflag))
	((pl_pgn *) this)->compute_area();
}



struct checklists{
    int endvt;
    int edgeno;
    checklists *next;
};

static checklists *checklist=0;

static int forbidden_intersection(const pl_pgn &pgn, const checklists *cl1, const checklists *cl2)
{
    if (cl1->endvt == cl2->endvt)
	return 0;
    return do_intersect(pgn.edge(cl1->edgeno), pgn.edge(cl2->edgeno));
}

int pl_pgn::insertion_check(int vnum, int pred, int succ) const
{
    checklists *above, *below;
    checklists       *e1, *e2;
// search between which edges 'vnum' lies
    above = 0; below = checklist;
    while (below != 0 && is_below(vertex(vnum), pl_line(vertex(below->endvt),
						    direction(below->edgeno)))) {
	above = below; below = below->next;
    }
// insert the two edges starting in vertex vnum
    e1 = new checklists;
    e2 = new checklists;
    e2->next = below;
    e1->next = e2;
    if (above == 0) checklist = e1; else above->next = e1;
// waarom gebruikt volgende regel niet directions ?????
    if (cross(vertex(pred) - vertex(vnum), vertex(succ) - vertex(vnum)) < 0) {
    // vnum-pred lies above vnum-succ
	e1->edgeno = pred;
	e1->endvt = pred;
	e2->edgeno = vnum;
	e2->endvt = succ;
   } else {	
    // vnum-pred lies below vnum-succ
	e1->edgeno = vnum;
	e1->endvt = succ;
	e2->edgeno = pred;
	e2->endvt = pred;
    }
    if (above != 0 && forbidden_intersection(*this, above, e1))
	return 1;
    if (below != 0 && forbidden_intersection(*this, below, e2))
	return 1;
    return 0;
}

int pl_pgn::transition_check(int vnum, int tonum, int edgeno) const
{  
    checklists *above, *current;
// search between which edges 'vnum' lies
    above = 0; current = checklist;
    while (current->endvt != vnum) {
	above = current; current = current->next;
    }
    current->endvt = tonum;
    current->edgeno = edgeno;
    if (above != 0 && forbidden_intersection(*this, above, current))
	return 1;
    if (current->next != 0 && forbidden_intersection(*this, current, current->next))
	return 1;
    return 0;
}

int pl_pgn::deletion_check(int vnum) const
{
    checklists *above, *current, *below;
// search between which edges 'vnum' lies
    above = 0; current = checklist;
    while (current->endvt != vnum) {
	above = current; current = current->next;
    }
    if (current->next==0 || current->next->endvt != vnum) {
	return 1;
    }
    below = current->next->next;
    if (above == 0)
	checklist = below;
    else
	above->next = below;
    if (above != 0 && below != 0 && forbidden_intersection(*this, above, below))
	return 1;
    return 0;
}

int pl_pgn::check_event(int vnum) const
{
    int             nb1, nb2, result;
    int             vertextype = 0;
    pl_edge	    e;
    pl_vec	    vec;
// nb1 and nb2 are the vertices preceding and succeeding 'vnum' in 'pg'
    nb1 = vnum == 0 ? size() - 1 : vnum - 1;
    nb2 = vnum == size() - 1 ? 0 : vnum + 1;
// decide what type of vertex 'vnum' is
// if both edges go to right then insertionpoint (type 0)
// if both edges come from the left then deletionpoint (type 3)
// otherwise a transitionpoint (type 1 or 2)
    if (order(nb1) < order(vnum))
	vertextype++;
    if (order(nb2) < order(vnum))
	vertextype += 2;
    switch (vertextype) {
    case 0:	// vnum is insertionpoint
	result = insertion_check(vnum, nb1, nb2);
	break;
    case 1:
	result = transition_check(vnum, nb2, vnum);
	break;
    case 2:
	result = transition_check(vnum, nb1, nb1);
	break;
    case 3:
	result = deletion_check(vnum);
	break;
    }
    return result;
}

void pl_pgn::check_simple()
{
    _flags.set(simpleflag);
// cleanup list of edges crossing sweepline
    checklists       *tmp;
    int i=0;
    while (checklist != NULL) {
	tmp = checklist;
	checklist = checklist->next;
	delete          tmp;
    }
    for(i=0; i < size(); i++) {
	if (check_event(element(i))) {
	    // zet fout bit
	    _flags.unset(is_simplef);
	    return;
	}
    }
    // zet goed bit
    _flags.set(is_simplef);
}


// next procedure goes wrong if leftmost vertex is duplicated.
void pl_pgn::check_clockwise()
{
    int leftnum, prevnum;
    int clockwise;
    _flags.set(clockwiseflag);
    if (size() <= 2)
	return;
    leftnum = element(0);   // leftmost vertex
    prevnum = (leftnum == 0) ? size()-1 : leftnum-1;
    if (vertex(prevnum).x() == vertex(leftnum).x()) {
	clockwise = vertex(prevnum).y() < vertex(leftnum).y();
    } else {
	clockwise = (cross(direction(prevnum), direction(leftnum)) < 0);
    }
    if (clockwise)
	_flags.set(is_clockwisef);
    else
	_flags.unset(is_clockwisef);
}

void pl_pgn::check_convex()
{
    int dir;
    int i;
    _flags.set(convexflag);
    if (size() < 4) {
	_flags.set(is_convexf);
	return;
    }
    dir = (cross(direction(size()-1), direction(0)) < 0);
    for (i=1; i<size(); i++)
	if ((cross(direction(i-1), direction(i)) < 0) != dir) {
	    _flags.unset(is_convexf);
	    return;
	}
    _flags.set(is_convexf);
}




