#include <plageo.h>

s_coord pl_unit_tfm::operator*(s_coord co) const
{
    return co;
}

// *****************

s_coord pl_uniscale::operator*(s_coord co) const
{
    return (_scale >= 0) ? _scale*co : -_scale*co;
}

pl_angle pl_uniscale::operator*(pl_angle theta) const
{
    pl_angle result;
    if (_scale >= 0)
	result = theta;
     else
	result = theta.value() + M_PI;
    result.normalise();
    return result;
}

pl_vec pl_uniscale::operator*(const pl_vec &vec) const
{
    return _scale * vec;
}

pl_unitvec pl_uniscale::operator*(const pl_unitvec &uvec) const
{
    return (_scale >= 0) ? uvec : -uvec;
}



// *******************************************

s_coord pl_translation::operator*(s_coord co) const
{
    return co;
}

pl_angle pl_translation::operator*(pl_angle theta) const
{
    return theta;
}

pl_vec pl_translation::operator*(const pl_vec &vec) const
{
    return vec + _trans;
}

pl_unitvec pl_translation::operator*(const pl_unitvec &uvec) const
{
    return uvec;
}

// *******************************************

pl_rotation::pl_rotation(pl_angle theta)
{
    _angle = theta;
    _angle.normalise();
    _rot[0] = cos_pp(_angle);
    _rot[1] = sin_pp(_angle);
}

s_coord pl_rotation::operator*(s_coord co) const
{
    return co;
}

pl_angle pl_rotation::operator*(pl_angle theta) const
{
    pl_angle result = theta + _angle;
    result.normalise();
    return result;
}

pl_vec pl_rotation::operator*(const pl_vec &v) const
{
    return
	pl_vec( _rot[0]*v.x() - _rot[1]*v.y(), _rot[1]*v.x() + _rot[0]*v.y());
}

pl_unitvec pl_rotation::operator*(const pl_unitvec &v) const
{
    return normalised(pl_vec( _rot[0]*v.x() - _rot[1]*v.y(),
		     _rot[1]*v.x() + _rot[0]*v.y()));
}


// *******************************************

s_coord pl_rotra::operator*(s_coord co) const
{
    return co;
}

pl_angle pl_rotra::operator*(pl_angle theta) const
{
    pl_angle result = theta + _angle;
    result.normalise();
    return result;
}

pl_vec pl_rotra::operator*(const pl_vec &v) const
{
    return
	pl_vec( _rot[0]*v.x() - _rot[1]*v.y(), _rot[1]*v.x() + _rot[0]*v.y())
	+ _trans;
}

pl_unitvec pl_rotra::operator*(const pl_unitvec &v) const
{
    return normalised(pl_vec( _rot[0]*v.x() - _rot[1]*v.y(),
		     _rot[1]*v.x() + _rot[0]*v.y()));
}


pl_rotra pl_rotra::operator*(const pl_rotra &tfm) const
{
    pl_rotra result;
    result._trans.set_x(_rot[0]*tfm._trans.x() -
		_rot[1]*tfm._trans.y() + _trans.x());
    result._trans.set_y(_rot[0]*tfm._trans.y() +
		_rot[1]*tfm._trans.x() + _trans.y());
    result._rot[0] = _rot[0]*tfm._rot[0] - _rot[1]*tfm._rot[1];
    result._rot[1] = _rot[0]*tfm._rot[1] + _rot[1]*tfm._rot[0];
    result._angle = _angle + tfm._angle;
    return result;
}

int pl_rotra::operator==(const pl_rotra &t) const
{
    return _trans.x()== t._trans.x() && _trans.y()== t._trans.y() &&
	   _angle == t._angle;
}

pl_rotra::pl_rotra(const pl_fixedvec &vec)
{
    _trans = vec;
    _rot[0] = 1;
    _rot[1] = 0;
    _angle = 0.0;
}

pl_rotra::pl_rotra(pl_angle theta)
{
    _trans = pl_vec(0, 0);
    _angle = theta;
    _angle.normalise();
    _rot[0] = cos_pp(_angle);
    _rot[1] = sin_pp(_angle);
}

pl_rotra::pl_rotra(pl_angle theta, const pl_fixedvec &vec)
{
    _trans = vec;
    _angle = theta;
    _angle.normalise();
    if (_angle == 0) {
	_rot[0] = 1;
	_rot[1] = 0;
    } else {
	_rot[0] = cos_pp(_angle);
	_rot[1] = sin_pp(_angle);
    }
}

void pl_rotra::set_angle(pl_angle theta)
{
    _angle = theta;
    _angle.normalise();
    _rot[0] = cos_pp(_angle);
    _rot[1] = sin_pp(_angle);
}

void pl_rotra::get_params(pl_angle &theta, pl_vec &vec) const
{
    theta = _angle;
    vec = _trans;
}

pl_angle pl_rotra::get_angle() const
{
    return _angle;
}

pl_rotra pl_rotra::inverse() const
{
    pl_rotra result;
    result._angle = -_angle;
    result._trans.set_x(-_trans.x()*_rot[0] - _trans.y()*_rot[1]);
    result._trans.set_y( _trans.x()*_rot[1] - _trans.y()*_rot[0]);
    result._rot[0] =  _rot[0];
    result._rot[1] = -_rot[1];
    return result;
}

// *******************************************


pl_ortho_tfm::pl_ortho_tfm(pl_angle theta, s_coord scale, const pl_fixedvec &vec)
{
    _trans = vec;
    _angle = theta;
    _angle.normalise();
    _scale = scale;
    if (_angle == 0) {
	_tfm[0] = _scale;
	_tfm[1] = 0;
    } else {
	_tfm[0] = _scale*cos_pp(_angle);
	_tfm[1] = _scale*sin_pp(_angle);
    }
}

s_coord pl_ortho_tfm::operator*(s_coord co) const
{
    return (_scale >= 0) ? co : -co;
}

pl_angle pl_ortho_tfm::operator*(pl_angle theta) const
{
    pl_angle result;
    if (_scale >= 0)
	result = theta + _angle;
    else
	result = theta + _angle + M_PI;
    result.normalise();
    return result;
}

pl_vec pl_ortho_tfm::operator*(const pl_vec &v) const
{
    return
	pl_vec( _tfm[0]*v.x() - _tfm[1]*v.y(), _tfm[1]*v.x() + _tfm[0]*v.y())
	+ _trans;
}

pl_unitvec pl_ortho_tfm::operator*(const pl_unitvec &v) const
{
    return normalised(pl_vec( _tfm[0]*v.x() - _tfm[1]*v.y(),
		     _tfm[1]*v.x() + _tfm[0]*v.y()));
}


pl_ortho_tfm pl_ortho_tfm::operator*(const pl_ortho_tfm &tfm) const
{
    pl_ortho_tfm result;
    result._trans.set_x(_tfm[0]*tfm._trans.x() -
		_tfm[1]*tfm._trans.y() + _trans.x());
    result._trans.set_y(_tfm[0]*tfm._trans.y() +
		_tfm[1]*tfm._trans.x() + _trans.y());
    result._tfm[0] = _tfm[0]*tfm._tfm[0] - _tfm[1]*tfm._tfm[1];
    result._tfm[1] = _tfm[0]*tfm._tfm[1] + _tfm[1]*tfm._tfm[0];
    result._angle = _angle + tfm._angle;
    result._scale = _scale * tfm._scale;
    return result;
}

int pl_ortho_tfm::operator==(const pl_ortho_tfm &t) const
{
    return _trans.x()== t._trans.x() && _trans.y()== t._trans.y() &&
	   _angle == t._angle && _scale == t._scale;
}

