%
%  MIPE DOCUMENT CLASS
%
% for the preparation of slides with Ipe
%
% $Modified: Tuesday, January  3, 1995 by otfried $
%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{mipe}[1995/01/03 v5.1 Making slides with Ipe]

% Font definitions as for 'slides' class
\InputIfFileExists{sfonts.cfg}
           {\typeout{**************************************^^J%
                     *^^J%
                     * Local config file sfonts.cfg used^^J%
                     *^^J%
                     **************************************}}%
           {\input{sfonts.def}}

% Paper size options

\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}

\DeclareOption{twoside}{%
  \ClassWarning{mipe}{No 'twoside' layout for slides}}
\DeclareOption{onecolumn}{}
\DeclareOption{twocolumn}{%
  \ClassWarning{mipe}{No 'twocolumn' layout for slides}}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}

% the 'landscape' option rotates the thing by 90 degrees

\DeclareOption{landscape}{
  \input{rotate.sty}
  \def\Ipage##1{\vbox to \paperheight{\vfill
      \hbox to \paperwidth{\hfill\rotate[l]{\Ipe{page##1.ipe}}\hfill}%
      \vfill}\newpage}
  }

% the 'nocolor' option sets all text in black

\DeclareOption{nocolor}{%
  \PassOptionsToPackage{nocolor}{ipe}}

% these two options include certain prologue files for our color printer
% this will have to be adapted for any other site

\DeclareOption{blueadj}{\special{header=/net/lib/ipe/color/blueadj.ps}%
  \special{header=/net/lib/ipe/color/resetaftertex.ps}%
  \special{header=/net/lib/ipe/color/beforetex.pro}}
\DeclareOption{blueadj}{\special{header=/net/lib/ipe/color/display.ps}%
  \special{header=/net/lib/ipe/color/resetaftertex.ps}%
  \special{header=/net/lib/ipe/color/beforetex.pro}}

% undocumented local option: use manual paper feed

\DeclareOption{manual}{\special{header=manual.pro}}

% default definition for \Ipage
% centers picture on full page

\def\Ipage#1{\vbox to \paperheight{\vfill
    \hbox to \paperwidth{\hfill\Ipe{page#1.ipe}\hfill}\vfill}\newpage}

\ExecuteOptions{a4paper}
\ProcessOptions

% need ipe package

\RequirePackage{ipe}

% use full paper for printing

\textwidth\paperwidth
\textheight\paperheight
\oddsidemargin -1in
\topmargin -1in
\headheight 0pt
\headsep 0pt
\pagestyle{empty}

%
% Font size translation from Ipe to sfonts.def
%

\newcommand{\MipeFont}[2]{\expandafter\def
  \csname @IPE@#1@font\endcsname{#2}}
%
\MipeFont{10}{\fontsize{10}{12pt}\selectfont}
\MipeFont{12}{\fontsize{12}{14pt}\selectfont}
\MipeFont{14}{\tiny}
\MipeFont{17}{\small}
\MipeFont{20}{\normalsize}
\MipeFont{24}{\large}
\MipeFont{25}{\large}  % old mipe size
\MipeFont{29}{\Large}
\MipeFont{30}{\Large}  % old mipe size
\MipeFont{34}{\LARGE}
\MipeFont{41}{\huge}
%
\renewcommand{\IPEcolfs}[2]{\expandafter\let\expandafter
  \@MIPEfont\csname @IPE@#2@font\endcsname
  \ifx\@MIPEfont\relax\errmessage{Unknown fontsize: #2}\fi
  \@MIPEfont\IPEcolor[rgb]{#1}}

%
% Font definition for large operators
%  (definition in OMXlcmex.fd has only one size)
%
\DeclareFontShape{OMX}{cmex}{m}{n}{%
  <10><12> cmex10%
  <13.82><16.59><19.91><23.89><28.66> s * [1.0419] cmex10%
  <34.4><41.28> sfixed * [29.88] cmex10}{}

%
% The rest is adapted from 'slides' class
%

\def\rmdefault{lcmss}        % no roman
\def\sfdefault{lcmss}
\def\ttdefault{lcmtt}
\def\itdefault{sl}
\def\sldefault{sl}
\def\bfdefault{bx}

\def\@setfontsize@parms#1#2#3{%
   \lineskip 2pt\relax%
   \abovedisplayskip #1\p@\relax
   \belowdisplayskip \abovedisplayskip\relax
   \abovedisplayshortskip 0pt\relax
   \belowdisplayshortskip 10pt\relax
  \setbox\strutbox=\hbox{\vrule \@height#2\p@\@depth#3\p@\@width\z@}%
  \baselineskip\baselinestretch\baselineskip
  \normalbaselineskip\baselineskip}

\DeclareMathSizes{13.82}{13.82}{10}{7}
\DeclareMathSizes{16.59}{16.59}{12}{7}
\DeclareMathSizes{19.91}{19.91}{16.59}{13.82}
\DeclareMathSizes{23.89}{23.89}{19.91}{16.59}
\DeclareMathSizes{28.66}{28.66}{23.89}{19.91}
\DeclareMathSizes{34.4}{34.4}{28.66}{23.89}
\DeclareMathSizes{41.28}{41.28}{34.4}{28.66}

\def\ifourteenpt{13.82}
\def\iseventeenpt{16.59}
\def\itwentypt{19.91}
\def\itwentyfourpt{23.89}
\def\itwentyninept{28.66}
\def\ithirtyfourpt{34.4}
\def\ifortyonept{41.28}

\def\normalsize{\@setfontsize\normalsize\itwentypt{25\p@}%
                \@setfontsize@parms{\itwentypt}{17}{7}}
\def\small{\@setfontsize\small\iseventeenpt{22\p@}
           \@setfontsize@parms{\iseventeenpt}{13.5}{5.6}}
\def\tiny{\@setfontsize\tiny\ifourteenpt{18\p@}%
          \@setfontsize@parms{\ifourteenpt}{10}{4}}
\def\large{\@setfontsize\large\itwentyfourpt{30\p@}%
           \@setfontsize@parms{\itwentyfourpt}{20}{8.5}}
\def\Large{\@setfontsize\Large\itwentyninept{36\p@}%
           \@setfontsize@parms{\itwentyninept}{27}{11}}
\def\LARGE{\@setfontsize\LARGE\ithirtyfourpt{42\p@}%
           \@setfontsize@parms{\ithirtyfourpt}{27}{11}}
\def\huge{\@setfontsize\huge\ifortyonept{51\p@}%
           \@setfontsize@parms{\ifortyonept}{27}{11}}
\let\Huge\huge
\let\footnotesize\small
\let\scriptsize\small

\def\baselinestretch{1}
\setlength\parindent{\z@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\normalsize

\SetSymbolFont{operators}{normal}{OT1}{lcmss}{m}{n}
\SetSymbolFont{letters}{normal}{OML}{lcmm}{m}{it}
\SetSymbolFont{symbols}{normal}{OMS}{lcmsy}{m}{n}
\SetSymbolFont{largesymbols}{normal}{OMX}{cmex}{m}{n}

\setlength\leftmargini   {38\p@}
\setlength\leftmarginii  {30\p@}
\setlength\leftmarginiii {20\p@}
\setlength\leftmarginiv  {15\p@}
\setlength\leftmarginv   {15\p@}
\setlength\leftmarginvi  {10\p@}
\def\@listi{\parsep .5\parskip
            \topsep \parsep
            \itemsep\parskip
            \partopsep \z@}
%
% The above definition is the original SliTex definition.
% This one is considered nicer at our department...
%
\def\@listi{\parsep .5\parskip
  \labelsep 10pt
  \tabbingsep \labelsep
  \leftmargin\leftmargini
  \labelwidth\leftmargini\advance\labelwidth-\labelsep
  \topsep \parsep
  \itemsep\parskip
  \partopsep \z@}


\def\@listii{\leftmargin\leftmarginii
             \labelwidth\leftmarginii
             \advance\labelwidth-\labelsep
             \parsep .5\parskip
             \topsep \parsep
             \itemsep\parskip}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep}
\def\@listiv{\leftmargin\leftmarginiv
             \labelwidth\leftmarginiv
             \advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
            \labelwidth\leftmarginv
            \advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
             \labelwidth\leftmarginvi
             \advance\labelwidth-\labelsep}
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\newenvironment{verse}{\let\\=\@centercr
                       \list{}{\itemsep       \z@
                               \itemindent    -15\p@
                               \listparindent \itemindent
                               \rightmargin   \leftmargin
                               \advance\leftmargin 15\p@}%
                       \item[]}
                      {\endlist}
\newenvironment{quotation}{\list{}{\listparindent 20\p@
                                   \itemindent\listparindent
                                   \rightmargin\leftmargin}%
                           \item[]}
                          {\endlist}
\newenvironment{quote}{\list{}{\rightmargin\leftmargin}\item[]}
                      {\endlist}
\newenvironment{description}{\list{}{\labelwidth\z@
                                     \itemindent-\leftmargin
                                     \let\makelabel\descriptionlabel}}
                            {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\newcommand\labelenumi{\arabic{enumi}.}
\newcommand\labelenumii{(\alph{enumii})}
\newcommand\labelenumiii{\roman{enumiii}.}
\newcommand\labelenumiv{\Alph{enumiv}.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\setlength\arraycolsep{8\p@}
\setlength\tabcolsep{10\p@}
\setlength\arrayrulewidth{.6\p@}
\setlength\doublerulesep{3\p@}
\labelsep 10pt
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{5\p@}
\setlength\fboxrule{.6\p@}
\def\theequation{\@arabic{\c@equation}}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\relax}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\relax}
\renewcommand{\cal}{\protect\pcal}
\newcommand{\pcal}{\@fontswitch{\relax}{\mathcal}}
\renewcommand{\mit}{\protect\pmit}
\newcommand{\pmit}{\@fontswitch{\relax}{\mathnormal}}
\renewcommand\footnoterule{}
\def\thefootnote{\fnsymbol{footnote}}
\long\def\@makefntext#1{
    \noindent
    \hangindent 10\p@
    \hbox to10\p@{\hss\@makefnmark}#1}

\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\pagenumbering{arabic}

%
\@twosidefalse
\onecolumn
\endinput
%% 
%% End of file `mipe.cls'.

