/* BASiC iNPUT/OUTPUT help to convert LiNUX->DOS 
 * LiNUX VERSION OF THE BASIC SCREEN ROUTiNES
 */
#include<ncurses.h>
#define write printw
#define writechar addch

void TextColor(int color) {
   static char oldcolor=99;
   char fore,back;
   if (color!=oldcolor)  {
      fore=color&7;
      back=(color&112)>>1;
      if ((color&8)==8) attrset(A_BOLD); else  attrset(A_NORMAL);
      if ((color&128)==128) attron(A_BLINK);
      if (fore==0&&back==0)
        attron((attr_t)COLOR_PAIR(64));
      else
        attron((attr_t)COLOR_PAIR(fore+back));
      oldcolor=color;
   }
}


int colortab(int a) /* convert LiNUX Color code to DOS-standard */{
   switch(a) {
    case 0 : return COLOR_BLACK;
    case 1 : return COLOR_BLUE;
    case 2 : return COLOR_GREEN;
    case 3 : return COLOR_CYAN;
    case 4 : return COLOR_RED;
    case 5 : return COLOR_MAGENTA;
    case 6 : return COLOR_YELLOW;
    case 7 : return COLOR_WHITE;
   }
}

void init_bio_crt() {
   int x,y;
   printf("\e(U");
   initscr();
   if(!has_colors()) {	   
      endwin();
      fprintf(stderr, "\ncolor not supported \n");
      exit(1);
   }
   start_color();
   scrollok(stdscr, FALSE);
   meta(stdscr, TRUE);
   nocbreak();
   noecho();
   keypad(stdscr, TRUE);
   nodelay(stdscr, TRUE);
   nonl();
   raw();
   ESCDELAY=0;
   COLORS=64;
   for (x = 1; x < 65; x++) {
      init_pair(x, colortab(x % 8),colortab(x / 8));
   }
  
}

void exit_bio_crt() {
   endwin();
}
