unsigned char oldColor=7;
char *AvatarColor(int col){
   char *tmp;
   tmp=(char *)malloc(4);
   if (col==oldColor) return NULL;
   sprintf(tmp,"%c",col);
   oldColor=col;
   return tmp;
}
char *strupr(char *str){
   int x;
   for (x=0;x<=strlen(str);x++)
      str[x]=toupper(str[x]);
   return str;
}

char *PCBoardColor(int col){
   char *a;
   if (col==oldColor) return NULL;
   a=(char *)malloc(4);
   sprintf(a,"@X%02x",col);
   a=strupr(a);
   oldColor=col;   
   return a;
}

char *AnsiColor(unsigned char col){
   char *a;
   if (col==oldColor) return NULL;
   a=(char *)malloc(30);
   sprintf(a,"");
   if ((oldColor>=128)&&(col<128)) {
      sprintf(a,"[0m");
      oldColor=7;
      if (col==7) return a;
   }
   sprintf(a,"%s[",a);
   if (((col&8)!=8)&((oldColor&8)==8)) { 
      sprintf(a,"%s0;",a);
      oldColor=oldColor&15;
   }
   if (((col&8)==8)&((oldColor&8)!=8)) sprintf(a,"%s1;",a);   

   if ((col&128)==128) {
      sprintf(a,"%s5",a);
      if ((col&15)!=(oldColor&15)||(col&112)!=(oldColor&112))
	sprintf(a,"%s;",a);
   }
   
   if ((col&15)!=(oldColor&15))
     switch (col&7) {
      case 0:
	sprintf(a,"%s30",a);
	break;
      case 1:
	sprintf(a,"%s34",a);
	break;
      case 2:
	sprintf(a,"%s32",a);
	break;
      case 3:
	sprintf(a,"%s36",a);
	break;
      case 4:
	sprintf(a,"%s31",a);
	break;
      case 5:
	sprintf(a,"%s35",a);
	break;
      case 6:
	sprintf(a,"%s33",a);
	break;
      case 7:
	sprintf(a,"%s37",a);
	break;
     }   
   if (((col&15))!=(oldColor&15)&&(col&112)!=(oldColor&112)) 
     sprintf(a,"%s;",a);
   if ((col&112)!=(oldColor&112))
     switch ((col&112)>>4) {
      case 0:
	sprintf(a,"%s40",a);
	break;
      case 1:
	sprintf(a,"%s44",a);
	break;
      case 2:
	sprintf(a,"%s42",a);
	break;
      case 3:
	sprintf(a,"%s46",a);
	break;
      case 4:
	sprintf(a,"%s41",a);
	break;
      case 5:
	sprintf(a,"%s45",a);
	break;
      case 6:
	sprintf(a,"%s43",a);
	break;
      case 7:
	sprintf(a,"%s47",a);
	break;
     }   
   sprintf(a,"%sm",a); 
   oldColor=col;
   return a;
}

int SelectSaveMode() {
   clrline();
   stri[1]="Clearscreen";
   stri[2]="Home";
   stri[3]="None";
   return auswahl(3,16,1);
}

char *EnterName(char *b) {
   char *a;
   char *ext;
   clrline();
   move(LINES-1,0);
   CoolWrite("Enter Filename :");
   a="";
   a=inputfield(a,60,16,LINES-1);
   if (strlen(a)==0) a=strdup("NONAME");
   ext=strchr(a,'.');
   if (ext==NULL) a=strcat(a,b);
   return a;
}

int CharCount(int d,int e,int a,int chr) {
   int b,c=0;
   for (b=d;b<=e;b++)
     if ((Screen[ActivePage][a][b<<1]==chr)&(Screen[ActivePage][a][(b<<1)+1]==Screen[ActivePage][a][(d<<1)+1])) c++; else break;
   return c;
}

int Numberofchars(int a) {
   int b,c=0;
   for (b=0;b<=79;b++) 
     if ( ( (Screen[ActivePage][a][b<<1]!=32) & (Screen[ActivePage][a][b<<1]!=0) 
	  )|
	  ((Screen[ActivePage][a][(b<<1)+1]&112)!=0) ) c=b;
   return c;
}

void save() {
   char ch,*Name,*s;
   FILE *fp;
   int x,y,z,chnum;
   oldColor=0;
   stri[1]="aNsi";
   stri[2]="aVatar";
   stri[3]="Pcboard";
   stri[4]="aScii";
   stri[5]="Binary";
   stri[6]="C";
   stri[7]="Abort";
   move(LINES-1,0);
   x=auswahl(7,0,1);
   if (LastLine>=MaxLines) LastLine=MaxLines-1;
   switch(x){
    case 1: /*ANSI Save*/
      Name=EnterName(".ans");
      fp=fopen(Name,"wb");
      switch(SelectSaveMode()) {
       case 1:
	 fprintf(fp,"[2J");
	 break;
       case 2:
	 fprintf(fp,"[1;1H");
	 break;
      }
      for (y=0;y<=LastLine;y++) {
/*	if (y>0) if (Numberofchars(y-1)>=79) fprintf(fp,"[A");*/
	 chnum=Numberofchars(y);
	 for (x=0;x<=chnum;x++) {
	    z=CharCount(x,chnum,y,' '); 
	    if ((z>2)&((Screen[ActivePage][y][(x<<1)+1]&112)==0)) {
	       fprintf(fp,"[%dC",z);
	       x+=z-1;
	    } else {
	       if (Screen[ActivePage][y][x<<1]==0) Screen[ActivePage][y][x<<1]=32;
	       s=AnsiColor(Screen[ActivePage][y][(x<<1)+1]);
	       if (s!=NULL) fprintf(fp,"%s",s);
	       fputc(Screen[ActivePage][y][x<<1],fp);
	    }
	 }	 
	 fputc(10,fp);
      }
      fprintf(fp,"[0m");

      SauceDescr.DataType=1;
      SauceDescr.FileType=1;
      SauceDescr.TInfo1=80;
      SauceDescr.TInfo2=LastLine;
      if (SaveSauce==TRUE) AppendSauce(fp);
      
      fclose(fp);
      break;      
    case 2: /*AVATAR Save*/
      Name=EnterName(".avt");      
      fp=fopen(Name,"wb");
      switch(SelectSaveMode()) {
       case 1:
	 fputc('',fp);
	 break;
       case 2:
	 fprintf(fp,"");
	 break;
      }
      for (y=0;y<=LastLine;y++) {
	 chnum=Numberofchars(y);
	 for (x=0;x<=chnum;x++) {
	    z=CharCount(x,chnum,y,Screen[ActivePage][y][x<<1]);	    
	    s=AvatarColor(Screen[ActivePage][y][(x<<1)+1]);
	    if (s!=NULL) fprintf(fp,"%s",s);
	    if ((z>2)&((Screen[ActivePage][y][(x<<1)+1]&112)==0)) {
	       fprintf(fp,"%c%c",Screen[ActivePage][y][x<<1],z);
	       x+=z-1;
	    } else {
	       if (Screen[ActivePage][y][(x<<1)+1]==0) fputc(0,fp);
	       if (Screen[ActivePage][y][x<<1]==0) Screen[ActivePage][y][x<<1]=32;
	       fputc(Screen[ActivePage][y][x<<1],fp);
	    }	    
	 }
	 fputc(10,fp);
      }
      fprintf(fp,"");
      SauceDescr.DataType=1;
      SauceDescr.FileType=5;
      if (SaveSauce==TRUE) AppendSauce(fp);
      fclose(fp);
      break;
    case 3:
      Name=EnterName(".pcb");      
      fp=fopen(Name,"wb");
      switch(SelectSaveMode()) {
       case 1:
	 fprintf(fp,"@CLS@");
	 break;
       case 2:
	 fprintf(fp,"@HOME@");
	 break;
      }
      for (y=0;y<=LastLine;y++) {
	   for (x=0;x<=Numberofchars(y);x++) {	    
	      if (Screen[ActivePage][y][x<<1]==0) Screen[ActivePage][y][x<<1]=32;
	      s=PCBoardColor(Screen[ActivePage][y][(x<<1)+1]);
	      if (s!=NULL) fprintf(fp,"%s",s);
	      fputc(Screen[ActivePage][y][x<<1],fp);
	   }
	 fputc(10,fp);
      }
      SauceDescr.DataType=1;
      SauceDescr.FileType=4;
      SauceDescr.TInfo1=80;
      SauceDescr.TInfo2=LastLine;
      if (SaveSauce==TRUE) AppendSauce(fp);

      fclose(fp);
      break;      
    case 4: 
      Name=EnterName(".asc");
      fp=fopen(Name,"wb");
      for (y=0;y<=LastLine;y++) {
	 for (x=0;x<=Numberofchars(y);x++) {
	    if (Screen[ActivePage][y][x<<1]==0) Screen[ActivePage][y][x<<1]=32;
	    fputc(Screen[ActivePage][y][x<<1],fp);
	 }	 
	 fputc(10,fp);
      }
      SauceDescr.DataType=1;
      SauceDescr.FileType=0;
      SauceDescr.TInfo1=80;
      SauceDescr.TInfo2=LastLine;
      if (SaveSauce==TRUE) AppendSauce(fp);
      fclose(fp);
      break;      
    case 5:
      Name=EnterName(".bin");
      fp=fopen(Name,"wb");
      for (y=0;y<=LastLine;y++) {
	 for (x=0;x<=159;x++)
	   fputc(Screen[ActivePage][y][x],fp);
      }
      fclose(fp);
      break;
    case 6:
      Name=EnterName(" ");
      fp=fopen(Name,"wb");
      fprintf(fp,"unsigned char %s[%d]={\n",Name,(LastLine+1)*160);
      for (y=0;y<=LastLine;y++) {
	 for (x=0;x<=159;x++) {
	    fprintf(fp,"%d",Screen[ActivePage][y][x]);
	    if (x<159) fputc(',',fp);
	 }
	 if (y<LastLine) fputc(',',fp); else fprintf(fp,"};");
	 fputc(10,fp);
      }
      SauceDescr.DataType=5;
      SauceDescr.FileType=40;
  /*    if (SaveSauce==TRUE) AppendSauce(fp); */
      fclose(fp);
      break;
   }   
}
