/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Application.cc,v $
$Revision: 1.12 $
$Date: 1997/07/03 04:18:28 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Application.cc,v $
Revision 1.12  1997/07/03 04:18:28  andrewm
Minor changes to deal with a few cases from inserting copyright notices.

Revision 1.11  1997/07/02 04:44:48  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.10  1997/07/01 03:54:32  andrewm
Changes in the way code is generated.  Now there is an initial event
function that must be called after construction but before any
other events are triggered.  This is to help integration of generated
classes into a class hierarchy.

Revision 1.9  1997/03/18 06:50:58  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.8  1997/03/04 06:32:47  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.7  1997/02/23 23:44:01  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.6  1996/11/17 21:50:48  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

// Revision 1.5  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.5  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.4  1996/08/05  01:26:53  andrewm
// checkpoint
//
// Revision 1.4  1996/08/05  01:26:53  andrewm
// checkpoint
//
// Revision 1.3  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.2  1996/07/15  01:22:04  andrewm
// checkpoint again
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/

#include "Application.h"
#include "MainWindow.h"
#include "Document.h"
#include "Command.h"

#include <assert.h>
#include <strstream.h>
#include <X11/Xmu/Editres.h>
#include <Xm/Xm.h>
#include <Xm/AtomMgr.h>
#include <Xm/Protocols.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Application.cc,v $ $Revision: 1.12 $" ;

static String fallback_resources[] =
{
#include "gsmedit_fallback.cc"
	NULL
} ;

/*
STATIC MEMBER DEFINITIONS
*/

Application *Application::_instance = NULL ;

/*
FUNCTION DEFINITIONS
*/

Application *Application::
instance()
{
	assert(_instance != NULL) ;
	return _instance ;
}

Application *Application::
instance(
	Application *appl_instance)
{
	assert(_instance == NULL) ;
	delete _instance ;
	_instance = appl_instance ;
	return _instance ;
}

Application::
Application(void) :
		_progname(NULL),
		_display(NULL),
		_appl_context(NULL),
		_main_window(NULL),
		_deleteWindow_command(NULL),
		_document(NULL)
{
}

Application::
~Application(void)
{
	delete _deleteWindow_command ;
	delete _main_window ;
	delete _document ;
}

void Application::
initialize(
	int *argcp,
	char **argv)
{
	_progname = *argv ;
	XtSetLanguageProc(NULL, NULL, NULL) ;

	Arg args[10] ;
	Cardinal n = 0 ;
	XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING) ; n++ ;
	XtSetArg(args[n], XmNkeyboardFocusPolicy, XmEXPLICIT) ; n++ ;
	_widget = XtOpenApplication(&_appl_context, className(),
		NULL, 0, argcp, argv, fallback_resources,
		sessionShellWidgetClass, args, n) ;
	_display = XtDisplay(_widget) ;
	installDestroyHandler() ;

	XtAddCallback(_widget, XtNdieCallback, dieCallback, (XtPointer)this) ;
	XmAddWMProtocolCallback(_widget,
		XmInternAtom(_display, "WM_DELETE_WINDOW", False),
		deleteWindowCallback, (XtPointer)this) ;
	XtAddEventHandler(_widget, (EventMask)0, True,
		_XEditResCheckMessages, NULL) ;

	template_get_appl_resources() ;
	_document = template_create_document() ;
	if (!_deleteWindow_command)
	{
		_deleteWindow_command = new SimpleCommand<Application>(
			this, Application::exit_appl) ;
	}
	_main_window = template_create_main_window("mainWindow", this) ;
	_main_window->manage() ;

	XtRealizeWidget(_widget) ;
	template_realize() ;

	if (*argcp > 1)
		_document->open(*++argv, false) ;
	else
		_document->new_doc() ;

	XtAppMainLoop(_appl_context) ;
}

void Application::
exit_appl(void)
{
	die() ;
}

void Application::
deleteWindow_command(
	Command *new_command)
{
	delete _deleteWindow_command ;
	_deleteWindow_command = new_command ;
}

void Application::
title(
	const char *title_string)
{
	ostrstream sout ;
	sout << _progname << ": " << title_string << ends ;
	const char *str = sout.str() ;
	setValue(XmNtitle, (XtArgVal)str) ;
	setValue(XmNiconName, (XtArgVal)str) ;
}

void Application::
deleteWindow()
{
	if (_deleteWindow_command)
		_deleteWindow_command->execute() ;
}

void Application::
die()
{
	setValue(XtNjoinSession, False) ;
	exit(0) ;
}

void Application::
deleteWindowCallback(
	Widget widget,
	XtPointer closure,
	XtPointer call_data)
{
	Application *appl = (Application *)closure ;
	appl->deleteWindow() ;
}

void Application::
dieCallback(
	Widget widget,
	XtPointer closure,
	XtPointer call_data)
{
	Application *appl = (Application *)closure ;
	appl->die() ;
}
