/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Application.h,v $
$Revision: 1.10 $
$Date: 1997/07/02 04:44:48 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Application.h,v $
Revision 1.10  1997/07/02 04:44:48  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.9  1997/03/18 06:50:58  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.8  1997/03/04 06:32:47  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.7  1997/02/23 23:44:01  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.6  1996/11/17 21:50:48  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

 * Revision 1.5  1996/09/22  01:46:34  andrewm
 * pre-alpha release
 *
 * Revision 1.5  1996/09/22  01:46:34  andrewm
 * pre-alpha release
 *
 * Revision 1.4  1996/08/05  01:26:53  andrewm
 * checkpoint
 *
 * Revision 1.4  1996/08/05  01:26:53  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/15  01:22:04  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/07/13  19:32:43  andrewm
 * Initial revision
 *
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////
// Application.h: 
////////////////////////////////////////////////////////////
 *--
 */
#ifndef _Application_h_
#define _Application_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "UIComponent.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command ;
class MainWindow ;
class Document ;

class Application :
	public UIComponent
{
public:
	static Application *instance() ;
	static Application *instance(Application *appl_instance) ;

	virtual ~Application() ;
	virtual const char *className() const { return "Application" ; }

	void initialize(int *argcp, char **argv) ;
	void exit_appl() ;

	Display *display() const { return _display ; }
	XtAppContext appl_context() const { return _appl_context ; }
	MainWindow *main_window() const { return _main_window ; }
	Document *document() const { return _document ; }
	void deleteWindow_command(Command *new_command) ;
	void title(const char *title_string) ;

protected:
	Application() ;
	virtual void template_get_appl_resources() {}
	virtual void template_realize() {}
	virtual MainWindow *template_create_main_window(
		const char *name, Application *appl) = 0 ;
	virtual Document *template_create_document() = 0 ;

protected:
	const char *_progname ;
	Display *_display ;
	XtAppContext _appl_context ;
	MainWindow *_main_window ;
	Document *_document ;

private:
	static Application *_instance ;

private:
	Command *_deleteWindow_command ;

private:
	void deleteWindow() ;
	void die() ;

private:
	static void deleteWindowCallback(Widget widget, XtPointer closure,
		XtPointer call_data) ;
	static void dieCallback(Widget widget, XtPointer closure,
		XtPointer call_data) ;
} ;



#endif /* _Application_h_ */
