/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Dialog.cc,v $
$Revision: 1.9 $
$Date: 1997/07/02 04:44:48 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Dialog.cc,v $
Revision 1.9  1997/07/02 04:44:48  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.8  1997/04/12 21:14:56  andrewm
Checkpoint after adding the event dialog.

Revision 1.7  1997/04/08 04:34:23  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.6  1997/02/23 23:44:02  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.5  1996/11/14 06:20:45  andrewm
checkpoint

// Revision 1.4  1996/10/01  04:40:29  andrewm
// checkpoint and revision
//
// Revision 1.3  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <assert.h>

#include "Dialog.h"
#include "Command.h"
#include <Xm/Xm.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: Dialog.cc,v $ $Revision: 1.9 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

Dialog::
Dialog() :
		_ok_command(NULL),
		_cancel_command(NULL),
		_help_command(NULL)
{
}

Dialog::
~Dialog()
{
	delete _ok_command ;
	delete _cancel_command ;
	delete _help_command ;
}

void Dialog::
manage() const
{
	if (!_ok_command)
	{
		Widget w = XtNameToWidget(_widget, "OK") ;
		if (w) XtSetSensitive(w, False) ;
	}
	if (!_cancel_command)
	{
		Widget w = XtNameToWidget(_widget, "Cancel") ;
		if (w) XtUnmanageChild(w) ;
	}
	if (!_help_command)
	{
		Widget w = XtNameToWidget(_widget, "Help") ;
		if (w) XtSetSensitive(w, False) ;
	}
	UIComponent::manage() ;
}

void Dialog::
ok_command(
	Command *command)
{
	delete _ok_command ;
	_ok_command = command ;
}

void Dialog::
cancel_command(
	Command *command)
{
	delete _cancel_command ;
	_cancel_command = command ;
}

void Dialog::
help_command(
	Command *command)
{
	delete _help_command ;
	_help_command = command ;
}

void Dialog::
ok()
{
	if (_ok_command)
		_ok_command->execute() ;
}

void Dialog::
cancel()
{
	if (_cancel_command)
		_cancel_command->execute() ;
}

void Dialog::
help()
{
	if (_help_command)
		_help_command->execute() ;
}

void Dialog::
install_callbacks()
{
	XtAddCallback(_widget, XmNokCallback, okCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNcancelCallback, cancelCallback, (XtPointer)this) ;
	XtAddCallback(_widget, XmNhelpCallback, helpCallback, (XtPointer)this) ;
}

void Dialog::
okCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_OK) ;
	Dialog *dialog = (Dialog *)closure ;
	dialog->ok() ;
}

void Dialog::
cancelCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_CANCEL) ;
	Dialog *dialog = (Dialog *)closure ;
	dialog->cancel() ;
}

void Dialog::
helpCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	assert(((XmAnyCallbackStruct *)call_data)->reason == XmCR_HELP) ;
	Dialog *dialog = (Dialog *)closure ;
	dialog->help() ;
}
