/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MenuComponent.h,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:44:52 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MenuComponent.h,v $
Revision 1.7  1997/07/02 04:44:52  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/03/18 06:50:59  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.5  1997/03/04 06:32:48  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/23 23:44:05  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/11/17 21:50:48  andrewm
Converting to the new version of g++ (2.7.2) and now everything
is under CVS.

Revision 1.2  1996/09/22 01:46:34  andrewm
pre-alpha release

 * Revision 1.1  1996/08/05  01:35:32  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/08/05  01:35:32  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _MenuComponent_h_
#define _MenuComponent_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "UIComponent.h"
#include <assert.h>
#include <list>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command ;

class MenuComponent :
	public UIComponent
{
public:
	virtual const char *className() const { return "MenuComponent" ; }

	virtual void add(MenuComponent *component) { assert(0) ; }
	virtual void remove(MenuComponent *component) { assert(0) ; }
	virtual void command(Command *new_command) { assert(0) ; }

protected:
	MenuComponent() {}
} ;

class MenuComposite :
	public MenuComponent
{
public:
	typedef list<MenuComponent *> MenuComponentList ;
	typedef list<MenuComponent *>::iterator MenuComponentListIter ;
	typedef list<MenuComponent *>::const_iterator MenuComponentListConstIter ;

public:
	virtual ~MenuComposite() ;

	virtual const char *className() const { return "MenuComposite" ; }
	virtual void manage() const ;

	virtual void add(MenuComponent *component) {
		_component_list.push_back(component) ; }
	virtual void remove(MenuComponent *component) {
		_component_list.remove(component) ; }

protected:
	MenuComposite() {}

protected:
	list<MenuComponent *> _component_list ;

private:
	MenuComposite& operator =(const MenuComposite&) ; // no assignments
} ;

class MenuLeaf :
	public MenuComponent
{
public:
	virtual ~MenuLeaf() ;

	virtual const char *className() const { return "MenuLeaf" ; }

	virtual void command(Command *new_command) ;

protected:
	MenuLeaf() : _command(0) {}

protected:
	Command *_command ;

protected:
	static void activateCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
} ;


#endif /* _MenuComponent_h_ */
