/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: ObserverMenu.h,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:44:53 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: ObserverMenu.h,v $
Revision 1.3  1997/07/02 04:44:53  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1996/09/22 01:46:34  andrewm
pre-alpha release

 * Revision 1.1  1996/07/27  20:58:10  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/07/27  20:58:10  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _ObserverMenu_h_
#define _ObserverMenu_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MenuButton.h"
#include "MenuPulldown.h"
#include "Observer.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

template<class Obsvd>
class ObserverMenuButton :
	public MenuButton,
	public Observer
{
public:
	typedef bool (Obsvd::* GetState)() ;

	ObserverMenuButton(const char *name, UIComponent *parent) ;

	void observe(Obsvd *subject, GetState state_func) ;

	virtual void update(Subject *subject) ;

private:
	Obsvd *_observed ;
	GetState _get_state ;
} ;

template<class Obsvd>
class ObserverMenuPulldown :
	public MenuPulldown,
	public Observer
{
public:
	typedef bool (Obsvd::* GetState)() ;

	ObserverMenuPulldown(const char *name, UIComponent *parent) ;

	void observe(Obsvd *subject, GetState state_func) ;

	virtual void update(Subject *subject) ;

private:
	Obsvd *_observed ;
	GetState _get_state ;
} ;


#endif /* _ObserverMenu_h_ */
