/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: RubberLine.h,v $
$Revision: 1.2 $
$Date: 1997/07/02 04:44:55 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: RubberLine.h,v $
Revision 1.2  1997/07/02 04:44:55  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.1  1997/03/18 06:51:00  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

 *--
 */
#ifndef _RubberLine_h_
#define _RubberLine_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Geom2d.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

/*
CLASS DEFINITIONS
*/

class RubberLine
{
public:
	RubberLine(const Point& origin) ;
	~RubberLine() ;
	void new_band(const Point& endpt) ;
	const Point& endpt() { return _endpt ; }

private:
	Point _origin ;
	Point _endpt ;
} ;



#endif /* _RubberLine_h_ */
