/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: TwoPartSelectionBox.h,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:44:57 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: TwoPartSelectionBox.h,v $
Revision 1.3  1997/07/02 04:44:57  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/04/12 21:14:56  andrewm
Checkpoint after adding the event dialog.

Revision 1.1  1997/04/08 04:34:25  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

 *--
 */
#ifndef _TwoPartSelectionBox_h_
#define _TwoPartSelectionBox_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "SelectionBox.h"

#include <X11/Intrinsic.h>
#include <Xm/List.h>
#include <vector>
#include <string>

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class TwoPartSelectionBox :
	public UIComponent
{
public:
	typedef string SelectPart ;
	typedef vector<SelectPart> SelectPartContainer ;
	typedef SelectPartContainer::reference SelectPartReference ;
	typedef SelectPartContainer::const_reference SelectPartConstReference ;

public:
	TwoPartSelectionBox(const char *name, UIComponent *parent) ;

	virtual const char *className() const { return "Selection" ; }

	void add_item(SelectPartConstReference part1,
		SelectPartConstReference part2, int position) ;
	void clear_list() ;
	SelectPart selection_text1() ;
	SelectPart selection_text2() ;
	SelectPart selected_1() ;
	SelectPart selected_2() ;

	void ok_command(Command *command) ;
	void apply_command(Command *command) ;
	void cancel_command(Command *command) ;
	void help_command(Command *command) ;

protected:
	Command *_ok_command ;
	Command *_apply_command ;
	Command *_cancel_command ;
	Command *_help_command ;

protected:
	virtual void ok() ;
	virtual void apply() ;
	virtual void cancel() ;
	virtual void help() ;
	virtual void list(XmListCallbackStruct *lcbs) ;

protected:
	static void listCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void okCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void applyCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void cancelCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void helpCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;

private:
	Widget _items_list ;
	Widget _text1_field ;
	Widget _text2_field ;
	Widget _ok_button ;
	SelectPartContainer _first_parts ;
	SelectPartContainer _second_parts ;

private:
	void set_text_field(Widget w, SelectPartConstReference text) ;
	int get_selected_position() ;
		// no assigments
	TwoPartSelectionBox& operator =(const TwoPartSelectionBox& sb) ;

private:
	static void text1_entry_cb(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void text2_entry_cb(Widget w, XtPointer closure,
		XtPointer call_data) ;
} ;


#endif /* _TwoPartSelectionBox_h_ */
