%{
#include "Chio.h"
#include <stack.h>
#include <list>
#include <strstream.h>

extern int hio_lineno ;
extern char *hio_text ;
extern int hio_lex() ;

ChioMap *hio_file_map ;
char *hio_source ;

static void report_duplicate_assignment(const ChioAssignment& assignment) ;

void hio_error(const char *s) ;
%}

%union {
	char character ;
	string *strlit ;
	ChioTerm *term ;
	ChioValue *value ;
	ChioAssignment *assign ;
	ChioMap *map ;
	ChioList *list ;
}

%token <term> TERM
%token <strlit> COMMENT

%type <map> statement_list
%type <value> statement_value
%type <assign> statement
%type <list> value_list

%start objfile
%%
objfile
	:	statement_list
			{
				hio_file_map = $1 ;
				yyerrok ;
			}
	;

statement_list
	:	statement_list ','
			{
				$$ = $1 ;
				yyerrok ;
			}
	|	statement_list ',' statement
			{
				ChioMap *map = $1 ;
				ChioAssignment *assign = $3 ;
				ChioMap::pair_iterator_bool result = map->insert(*assign) ;
				if (result.second != true)
					report_duplicate_assignment(*assign) ;
				delete assign ;
				$$ = map ;
				yyerrok ;
			}
	|	statement
			{
				ChioMap *map = new ChioMap() ;
				ChioAssignment *assign = $1 ;

				map->insert(*assign) ;
				delete assign ;
				$$ = map ;
				yyerrok ;
			}
	|	statement_list error
	|	statement_list error statement
			{
				ChioMap *map = $1 ;
				ChioAssignment *assign = $3 ;
				ChioMap::pair_iterator_bool result = map->insert(*assign) ;
				if (result.second != true)
					report_duplicate_assignment(*assign) ;
				delete assign ;
				$$ = map ;
				yyerrok ;
			}
	;

statement
	:	COMMENT TERM '=' statement_value
			{
				string *comment = $1 ;
				ChioValue *value = $4 ;
				value->comment() = *comment ;
				$$ = new ChioAssignment(*$2, *value) ;
				delete comment ;
				delete value ;
				yyerrok ;
			}
	|	TERM '=' statement_value
			{
				ChioValue *value = $3 ;
				$$ = new ChioAssignment(*$1, *value) ;
				delete value ;
				yyerrok ;
			}
	|	COMMENT TERM '=' error
			{
				string *comment = $1 ;
				$$ = new ChioAssignment(*$2,
					ChioValue(ChioValue::TermChioValue, *comment)) ;
				delete comment ;
			}
	|	TERM '=' error
			{
				$$ = new ChioAssignment(*$1, ChioValue()) ;
			}
	;

statement_value
	:	TERM
			{
				$$ = new ChioValue($1) ;
			}
	|	'[' statement_list rb
			{
				$$ = new ChioValue($2) ;
			}
	|	'[' value_list rb
			{
				$$ = new ChioValue($2) ;
			}
	|	'[' rb
			{
				$$ = new ChioValue(ChioValue::EmptyChioValue) ;
			}
	;

value_list
	:	value_list ','
	|	value_list ',' statement_value
			{
				ChioList *list = $1 ;
				ChioValue *value = $3 ;
				list->push_back(*value) ;
				delete value ;
				$$ = list ;
			}
	|	statement_value
			{
				ChioList *list = new ChioList() ;
				ChioValue *value = $1 ;
				list->push_back(*value) ;
				delete value ;
				$$ = list ;
			}
	;

rb
	:	']'
			{
				yyerrok ;
			}
	;
%%

static void
report_duplicate_assignment(
	const ChioAssignment& assignment)
{
	ostrstream out ;
	out << "duplicated assignment:" << assignment.first << ends ;
	hio_error(out.str()) ;
}

void
hio_error(
	const char *s)
{
	ostrstream out ;

	if (hio_source && *hio_source)
		out << hio_source << ':' ;
	if (hio_lineno > 0)
		out << hio_lineno << ':' ;
	if (*hio_text)
		out << "near \"" << hio_text << "\"" << ':' ;
	out << s << endl << ends ;

	cerr << out.str() ;
	return ;
}
