%option never-interactive
%option yylineno
%option noyywrap
%{
#include "Chio.h"
#include "ascii.h"
#include "parse.tab.h"

static string gather_multi_line() ;
static string *gather_comment() ;

extern void hio_error(const char *s) ;
%}

white	[ \t\n\r\v\f]
notword	[^ \t\n\r\v\f,"\[\]\{\}=]
other	.
%%
"/*" {
	hio_lval.strlit = gather_comment() ;
	return COMMENT ;
}

\/\/.*$ {
	hio_lval.strlit = new string(hio_text) ;
	return COMMENT ;
}

({notword}|\\.)+ {
	hio_lval.term = new ChioTerm(hio_text, ChioTerm::WordChioTerm,
		ChioTerm::ExternalChioTerm, hio_lineno) ;
	return TERM ;
}

\"([^\"]|\\.)*\" {
	hio_lval.term = new ChioTerm(hio_text, ChioTerm::StringChioTerm,
		ChioTerm::ExternalChioTerm, hio_lineno) ;
	return TERM ;
}

"{" {
	int line_no = hio_lineno ;
	hio_lval.term = new ChioTerm(gather_multi_line(),
		ChioTerm::MultiLineChioTerm, ChioTerm::ExternalChioTerm, line_no) ;
	return TERM ;
}

{white}	;

{other} {
		hio_lval.character = *hio_text ;
		return *hio_text ;
}
%%

static string
gather_multi_line()
{
	string str ;
	int c ;

	while ((c = yyinput()) != EOF)
	{
		if (c == '\\')
		{
			str += c ;
			c = yyinput() ;
			if (c == EOF)
			{
				hio_error("EOF reached before closing brace") ;
				break ;
			}
		}
		else if (c == '}')
			break ;
		str += c ;
	}

	return str ;
}

static string *
gather_comment()
{
	string *s = new string(hio_text) ;
	int c ;
	int next ;

	for (;;)
	{
		c = yyinput() ;
		*s += c ;
		if (c == EOF)
		{
			hio_error("unexpected EOF in a comment") ;
		}
		else if (c == '*')
		{
			next = yyinput() ;
			if (next == EOF)
			{
				hio_error("unexpected EOF in a comment") ;
			}
			else if (next == '/')
			{
				*s += next ;
				break ;
			}
			else
				unput(next) ;
		}
	}

	return s ;
}
