/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:
	gsm2cc -- GSM C++ compiler

$RCSfile: gsm2cc.cc,v $
$Revision: 1.5 $
$Date: 1997/07/14 02:30:32 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: gsm2cc.cc,v $
Revision 1.5  1997/07/14 02:30:32  andrewm
Checkpoint.  Rework makefiles.  Rework man pages.  Fixed PostScript problems.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <stdio.h>
#include <fstream.h>
#include <GetOpt.h>

#include "Chio.h"
#include "MachineGroup.h"
#include "TransitionCheckVisitor.h"
#include "StateCheckVisitor.h"
#include "CcHeaderVisitor.h"
#include "CcCodeVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: gsm2cc.cc,v $ $Revision: 1.5 $" ;

/*
FUNCTION DEFINITIONS
*/

main(
	int argc,
	char **argv)
{
	char *progname = *argv ;
	bool gen_header = true ;
	bool gen_code = true ;
	bool line_directives = true ;
	const char *header_ext = "h" ;
	const char *code_ext = "cc" ;

	GetOpt getopt(argc, argv, "hcle:o:") ;
	int option_char = EOF ;

	while ((option_char = getopt()) != EOF)
	{
		switch (option_char)
		{
		case 'h':
			gen_header = false ;
			break ;

		case 'c':
			gen_code = false ;
			break ;

		case 'l':
			line_directives = false ;
			break ;

		case 'e':
			header_ext = getopt.optarg ;
			break ;

		case 'o':
			code_ext = getopt.optarg ;
			break ;

		case ':':
		case '?':
		default:
			cerr << "Usage: " << progname <<
		" [-h] [-c] [-l ] [-e header_extension] [-o code_extension] [file ...]"
			<< endl ;
			return 1 ;
		}
	}

	int return_code = 0 ;
	while (getopt.optind < argc)
	{
		string filename(argv[getopt.optind++]) ;

		ifstream in_file(filename.c_str()) ;
		if (!in_file)
		{
			cerr << progname << ": Cannot open file \"" << filename
				<< "\" for reading" << endl ;
			return_code = 3 ;
			continue ;
		}

		ChioMap file_map ;
		in_file >> file_map ;
		MachineGroup machine_group(file_map) ;
		TransitionCheckVisitor trans_check ;

		machine_group.accept_visitor(trans_check) ;
		if (trans_check.discrepancies() != 0)
		{
			cerr << progname << ": " << filename <<
				": Transition Error: Event/State parameter mismatch" << endl ;
			cerr << trans_check ;
			return_code = 2 ;
			continue ;
		}

		StateCheckVisitor state_check ;
		machine_group.accept_visitor(state_check) ;
		if (state_check.discrepancies() != 0)
		{
			cerr << progname << ": " << filename <<
				": State configuration error" << endl ;
			cerr << state_check ;
			return_code = 2 ;
			continue ;
		}

		string::size_type suf_place = filename.rfind('.') ;
		string basename(filename.substr(0, suf_place)) ;
		basename += "." ;
		if (gen_header)
		{
			string headername(basename + header_ext) ;
			CcHeaderVisitor hg(headername) ;
			hg.visit(&machine_group) ;
		}

		if (gen_code)
		{
			string codename(basename + code_ext) ;
			CcCodeVisitor cg(filename, codename, line_directives) ;
			cg.visit(&machine_group) ;
		}
	}
	return return_code ;
}
