/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:
	gsm2dot -- transform GSM file to Dot files

$RCSfile: gsm2dot.cc,v $
$Revision: 1.5 $
$Date: 1997/07/14 02:30:32 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: gsm2dot.cc,v $
Revision 1.5  1997/07/14 02:30:32  andrewm
Checkpoint.  Rework makefiles.  Rework man pages.  Fixed PostScript problems.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <fstream.h>
#include <string.h>

#include "Chio.h"
#include "MachineGroup.h"
#include "DotVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: gsm2dot.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

main(
	int argc,
	char **argv)
{
	char *progname = *argv ;

	char *filename = *++argv ;
	if (filename)
	{
		hio_source = filename ;
		ifstream infile(filename) ;
		if (!infile)
		{
			cerr << progname << ": Cannot open \"" << filename
				<< "\" for reading: " << strerror(errno) << endl ;
			exit(1) ;
		}

		ChioMap file_map ;
		infile >> file_map ;
		MachineGroup mg(file_map) ;
		DotVisitor dotvisit(cout) ;
		mg.accept_visitor(dotvisit) ;
	}

	exit(0) ;
}
