/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: EventSelectionDialog.cc,v $
$Revision: 1.10 $
$Date: 1997/07/02 04:45:02 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: EventSelectionDialog.cc,v $
Revision 1.10  1997/07/02 04:45:02  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.9  1997/06/06 04:34:24  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.8  1997/05/31 21:12:41  andrewm
Checkpoint.  Things are working well.

Revision 1.7  1997/05/15 04:14:43  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.6  1997/04/08 04:34:29  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.5  1997/03/18 06:51:01  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.4  1996/11/14 06:21:12  andrewm
checkpoint

// Revision 1.3  1996/10/01  04:40:57  andrewm
// checkpoint and revision
//
// Revision 1.2  1996/09/22  01:47:02  andrewm
// pre-alpha release
//
// Revision 1.1  1996/08/05  01:27:42  andrewm
// Initial revision
//
// Revision 1.1  1996/08/05  01:27:42  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "EventSelectionDialog.h"
#include "Smachine.h"
#include "MachEvent.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: EventSelectionDialog.cc,v $ $Revision: 1.10 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

EventSelectionDialog::
EventSelectionDialog(
	const char *name,
	UIComponent *parent,
	Smachine *machine) :
		SelectionDialog(name, parent),
		_machine(machine)
{
	_machine->attach(this) ;
	update(_machine) ;
}

EventSelectionDialog::
~EventSelectionDialog()
{
	if (_machine)
		_machine->detach(this) ;
}

void EventSelectionDialog::
update(
	const Subject *subject)
{
	clear_list() ;
	selection_text(string()) ;

	if (_machine)
	{
		assert(subject == _machine) ;

		Smachine::MachEventList& event_list = _machine->event_list() ;
		for (Smachine::MachEventListIter e_iter = event_list.begin() ;
			e_iter != event_list.end() ; ++e_iter)
		{
			MachEvent *event = *e_iter ;
			add_item(event->name().c_str(), 0) ;
		}
	}
}

void EventSelectionDialog::
subject_deleted(
	Subject *subject)
{
	assert(subject == _machine) ;
	_machine = NULL ;
}
