/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: EventSelectionDialog.h,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:02 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: EventSelectionDialog.h,v $
Revision 1.5  1997/07/02 04:45:02  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/06/06 04:34:24  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.3  1997/03/18 06:51:01  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.2  1996/09/22 01:47:02  andrewm
pre-alpha release

 * Revision 1.1  1996/08/05  01:27:42  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/08/05  01:27:42  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _EventSelectionDialog_h_
#define _EventSelectionDialog_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "SelectionDialog.h"
#include "Observer.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Smachine ;

class EventSelectionDialog :
	public SelectionDialog,
	public Observer
{
public:
	EventSelectionDialog(const char *name, UIComponent *parent,
		Smachine *machine) ;
	~EventSelectionDialog() ;

	virtual const char *className() const { return "EventSelectionDialog" ; }

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

private:
	Smachine *_machine ;
} ;


#endif /* _EventSelectionDialog_h_ */
