/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: FileOpDialogDirector.cc,v $
$Revision: 1.3 $
$Date: 1997/07/02 04:45:04 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: FileOpDialogDirector.cc,v $
Revision 1.3  1997/07/02 04:45:04  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.2  1997/03/30 02:07:27  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.1  1997/03/04 06:34:40  andrewm
New director objects used for more complex dialogs.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "FileOpDialogDirector.h"
#include "QuestionDialog.h"
#include "FileSelectionDialog.h"
#include "Document.h"

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleXmCommand<FileOpDialogDirector> FODD_XmCommand ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: FileOpDialogDirector.cc,v $ $Revision: 1.3 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

FileOpDialogDirector::
FileOpDialogDirector(
	UIComponent *parent,
	Document& document) :
		SaveDialogDirector(parent, document),
		_file_select(new FileSelectionDialog("fileDialog", parent))
{
	_file_select->dir_mask("*.gsm") ;
	_file_select->ok_command(
		new FODD_XmCommand(this, FileOpDialogDirector::file_action)) ;
	_file_select->cancel_command(new NullXmCommand) ;
}

FileOpDialogDirector::
~FileOpDialogDirector()
{
	delete _file_select ;
}

void FileOpDialogDirector::
show_dialog()
{
	if (_document.modified())
		_question->manage() ;
	else
		_file_select->manage() ;
}

void FileOpDialogDirector::
save_yes()
{
	_document.save() ;
	_file_select->manage() ;
}

void FileOpDialogDirector::
save_no()
{
	_file_select->manage() ;
}
