/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: InputCommand.h,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:45:07 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: InputCommand.h,v $
Revision 1.6  1997/07/02 04:45:07  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/06/06 04:34:25  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.4  1997/03/12 03:13:06  andrewm
Checkpoint.  Things are working rather well.

Revision 1.3  1996/09/22 01:47:02  andrewm
pre-alpha release

 * Revision 1.2  1996/08/05  01:27:42  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/08/05  01:27:42  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/07/27  20:58:52  andrewm
 * Initial revision
 *
 * Revision 1.1  1996/07/15  01:22:32  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _InputCommand_h_
#define _InputCommand_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Command.h"
#include "Geom2d.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Document ;

class InputCommand :
	public XmCommand
{
public:
	InputCommand(Document *document) : _document(document) {}
	virtual void execute(XmAnyCallbackStruct *callback_data) ;

private:
	Document *_document ;
	Point _start_location ;
} ;


#endif /* _InputCommand_h_ */
