/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachEventDialogDirector.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:08 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachEventDialogDirector.cc,v $
Revision 1.5  1997/07/02 04:45:08  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/06/06 04:34:25  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.3  1997/04/16 04:06:14  andrewm
Checkpoint, as last major dialog is in.

Revision 1.2  1997/04/12 21:15:00  andrewm
Checkpoint after adding the event dialog.

Revision 1.1  1997/04/08 04:34:29  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "GsmDocument.h"
#include "Command.h"
#include "Smachine.h"
#include "MachEvent.h"
#include "DialogForm.h"
#include "SelectionBox.h"
#include "ParameterDialog.h"
#include "MachEventDialogDirector.h"
#include "CSutils.h"

#include <assert.h>
#include <Xm/Separator.h>


/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleCommand<MachEventDialogDirector> MEDD_Command ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MachEventDialogDirector.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MachEventDialogDirector::
MachEventDialogDirector(
	const char *name,
	UIComponent *parent,
	GsmDocument& document) :
		_document(document),
		_machine(NULL),
		_form(new DialogForm(name, parent))
{
	Arg args[10] ;
	Cardinal n ;

	n = 0 ;
	XtSetArg(args[n], XmNverticalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNhorizontalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNautoUnmanage, False) ; n++ ;
	_form->setValues(args, n) ;

	_event_selection = new SelectionBox("event_selection", _form) ;
	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNautoUnmanage, False) ; n++ ;
	_event_selection->setValues(args, n) ;
	_event_selection->ok_command(new SimpleXmCommand<MachEventDialogDirector>(
		this, MachEventDialogDirector::add_event)) ;
	_event_selection->cancel_command(
		new SimpleXmCommand<MachEventDialogDirector>(
		this, MachEventDialogDirector::delete_event)) ;
	_event_selection->manage() ;
	Widget list_widget = XtNameToWidget(_event_selection->widget(),
		"ItemsListSW.ItemsList") ;
	assert(list_widget != 0) ;
	XtAddCallback(list_widget, XmNbrowseSelectionCallback,
		list_cb, (XtPointer)this) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _event_selection->widget()) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep1 = XmCreateSeparator(_form->widget(), "sep1", args, n) ;
	XtManageChild(sep1) ;

	_event_params = new EventParameterDialog("event_params", _form) ;
	n = 0 ; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep1) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	_event_params->setValues(args, n) ;
	_event_params->manage() ;

	_document.attach(this) ;
}

MachEventDialogDirector::
~MachEventDialogDirector()
{
	delete _event_params ;
	delete _event_selection ;
	delete _form ;
	if (_machine)
		_machine->detach(this) ;
	_document.detach(this) ;
}

void MachEventDialogDirector::
show_dialog()
{
	update(&_document) ;
	_form->manage() ;
}

void MachEventDialogDirector::
dismiss_dialog()
{
	_form->unmanage() ;
}

void MachEventDialogDirector::
update(
	const Subject *subject)
{
	if (subject == &_document)
	{
		Smachine *old_machine = _machine ;
		_machine = _document.current_machine() ;
		if (old_machine != _machine)
		{
			if (old_machine)
			{
				old_machine->detach(this) ;
				clear_list() ;
			}
			if (_machine)
			{
				_machine->attach(this) ;
				update_event_list() ;
			}
		}
	}
	else if (subject == _machine)
	{
		clear_list() ;
		update_event_list() ;
	}
}

void MachEventDialogDirector::
subject_deleted(
	Subject *subject)
{
	_machine = NULL ;
	clear_list() ;
}

void MachEventDialogDirector::
add_event(
	XmAnyCallbackStruct *callback_data)
{
	XmSelectionBoxCallbackStruct *sbcs =
		(XmSelectionBoxCallbackStruct *)callback_data ;
	char *event_name = CSToText(sbcs->value) ;
	MachEvent *event = _machine->add_event(event_name) ;
	XtFree(event_name) ;
	_event_params->event(event) ;
}

void MachEventDialogDirector::
delete_event(
	XmAnyCallbackStruct *callback_data)
{
	XmSelectionBoxCallbackStruct *sbcs =
		(XmSelectionBoxCallbackStruct *)callback_data ;
	char *event_name = CSToText(sbcs->value) ;
	MachEvent *event = _machine->find_event(event_name) ;
	delete event ;
	XtFree(event_name) ;
}

void MachEventDialogDirector::
list_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	MachEventDialogDirector *dd = (MachEventDialogDirector *)closure ;
	XmListCallbackStruct *lcbs = (XmListCallbackStruct *)callback_data ;
	assert(lcbs->reason == XmCR_BROWSE_SELECT) ;

	char *event_name = CSToText(lcbs->item) ;
	MachEvent *event = dd->_machine->find_event(event_name) ;
	XtFree(event_name) ;
	if (event)
		dd->_event_params->event(event) ;
}

void MachEventDialogDirector::
clear_list()
{
	_event_selection->clear_list() ;
	_event_params->clear_list() ;
}

void MachEventDialogDirector::
update_event_list()
{
	Smachine::MachEventList& ev_list = _machine->event_list() ;
	for (Smachine::MachEventListIter ev_iter = ev_list.begin() ;
		ev_iter != ev_list.end() ; ++ev_iter)
	{
		MachEvent *event = *ev_iter ;
		_event_selection->add_item(event->name().c_str(), 0) ;
	}
}
