/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachEventDialogDirector.h,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:45:08 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachEventDialogDirector.h,v $
Revision 1.5  1997/07/02 04:45:08  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/06/06 04:34:25  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.3  1997/04/16 04:06:14  andrewm
Checkpoint, as last major dialog is in.

Revision 1.2  1997/04/12 21:15:00  andrewm
Checkpoint after adding the event dialog.

Revision 1.1  1997/04/08 04:34:30  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

 *--
 */
#ifndef _MachEventDialogDirector_h_
#define _MachEventDialogDirector_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "DialogDirector.h"
#include "Observer.h"

#include <X11/Intrinsic.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/
class GsmDocument ;
class Smachine ;
class DialogForm ;
class SelectionBox ;
class EventParameterDialog ;

/*
CLASS DEFINITIONS
*/
class MachEventDialogDirector :
	public DialogDirector,
	public Observer
{
public:
	MachEventDialogDirector(const char *name, UIComponent *parent,
		GsmDocument& document) ;
	~MachEventDialogDirector() ;

	virtual void show_dialog() ;
	virtual void dismiss_dialog() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

protected:
	void add_event(XmAnyCallbackStruct *callback_data) ;
	void delete_event(XmAnyCallbackStruct *callback_data) ;

private:
	static void list_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;

private:
	GsmDocument& _document ;
	Smachine *_machine ;
	DialogForm *_form ;
	SelectionBox *_event_selection ;
	EventParameterDialog *_event_params ;

private:
	void clear_list() ;
	void update_event_list() ;
} ;


#endif /* _MachEventDialogDirector_h_ */
