/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: StateDialogDirector.cc,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:45:11 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: StateDialogDirector.cc,v $
Revision 1.7  1997/07/02 04:45:11  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/06/21 02:21:33  andrewm
Checkpoint.  PostScript generator going well. A lot of small tweeks
all over to accomplish this.

Revision 1.5  1997/06/06 04:34:26  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.4  1997/05/31 21:12:42  andrewm
Checkpoint.  Things are working well.

Revision 1.3  1997/05/15 04:14:44  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.2  1997/04/24 03:20:46  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.1  1997/04/16 04:06:15  andrewm
Checkpoint, as last major dialog is in.

 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "Application.h"
#include "ParameterDialog.h"
#include "UnspecTransitionDialog.h"
#include "DialogForm.h"
#include "MenuButton.h"
#include "TextEditor.h"
#include "GsmDocument.h"
#include "DocPageState.h"
#include "StateDialogDirector.h"
#include "Smachine.h"
#include "State.h"

#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/
typedef SimpleCommand<StateDialogDirector> SDD_Command ;

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: StateDialogDirector.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/
StateDialogDirector::
StateDialogDirector(
	const char *name,
	UIComponent *parent,
	GsmDocument& document) :
		_doc(document),
		_page_state(document.page_state()),
		_current_state(NULL),
		_form(new DialogForm(name, parent)),
		_param_dialog(NULL),
		_trans_dialog(NULL),
		_code_button(NULL),
		_code_editor(NULL)
{
	Arg args[10] ;
	Cardinal n ;

	n = 0 ;
	XtSetArg(args[n], XmNverticalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNhorizontalSpacing, 10) ; n++ ;
	XtSetArg(args[n], XmNautoUnmanage, False) ; n++ ;
	_form->setValues(args, n) ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
	Widget name_work = XmCreateRowColumn(_form->widget(), "name_work",
		args, n) ;

	n = 0 ;
	Widget name_label = XmCreateLabel(name_work, "name_label", args, n) ;
	XtManageChild(name_label) ;

	n = 0 ;
	_name_entry = XmCreateTextField(name_work, "name_entry", args, n) ;
	XtAddCallback(_name_entry, XmNactivateCallback, name_entry_cb,
		(XtPointer)this) ;
	XtManageChild(_name_entry) ;
	XtManageChild(name_work) ;

	_param_dialog = new StateParameterDialog("param_dialog", _form) ;
	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, name_work) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	_param_dialog->setValues(args, n) ;
	_param_dialog->manage() ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _param_dialog->widget()) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	Widget sep = XmCreateSeparator(_form->widget(), "sep1", args, n) ;
	XtManageChild(sep) ;

	_trans_dialog = new UnspecTransitionDialog("trans_dialog", _form) ;
	n = 0 ; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	_trans_dialog->setValues(args, n) ;
	_trans_dialog->manage() ;

	n = 0 ;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, _trans_dialog->widget()) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	sep = XmCreateSeparator(_form->widget(), "sep2", args, n) ;
	XtManageChild(sep) ;

	_code_button = new MenuButton("edit_state_code", _form) ;
	n = 0 ; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
	XtSetArg(args[n], XmNtopWidget, sep) ; n++ ;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
	_code_button->setValues(args, n) ;
	_code_button->command(new SDD_Command(this,
		StateDialogDirector::edit_state_code)) ;
	_code_button->manage() ;
	_code_editor = new TextEditor("State", Application::instance()) ;
	_code_editor->save_command(new SDD_Command(this,
		StateDialogDirector::set_state_code)) ;

	_doc.attach(this) ;
	if (_page_state) _page_state->attach(this) ;
	update_page_state() ;
}

StateDialogDirector::
~StateDialogDirector()
{
	delete _code_editor ;
	delete _code_button ;
	delete _trans_dialog ;
	delete _param_dialog ;
	delete _form ;
	if (_page_state) _page_state->detach(this) ;
	_doc.detach(this) ;
}

void StateDialogDirector::
show_dialog()
{
	update(&_doc) ;
	_form->manage() ;
}

void StateDialogDirector::
dismiss_dialog()
{
	_form->unmanage() ;
}

void StateDialogDirector::
update(
	const Subject *subject)
{
	if (subject == &_doc)
		update_doc() ;
	else if (subject == _page_state)
		update_page_state() ;
	else if (subject == _current_state)
		update_current_state() ;
}

void StateDialogDirector::
subject_deleted(
	Subject *subject)
{
	_page_state = NULL ;
	_current_state = NULL ;
	update(_page_state) ;
}

void StateDialogDirector::
update_doc()
{
	DocPageState *old_page_state = _page_state ;
	_page_state = _doc.page_state() ;
	if (old_page_state != _page_state)
	{
		if (old_page_state) old_page_state->detach(this) ;
		if (_page_state) _page_state->attach(this) ;
		update_page_state() ;
	}
}

void StateDialogDirector::
update_page_state()
{
	if (_page_state)
	{
		State *old_state = _current_state ;
		_current_state = _page_state->current_state() ;
		if (old_state != _current_state)
		{
			if (old_state)
			{
				old_state->detach(this) ;
				if (_code_editor->modified())
				{
					old_state->code(ChioTerm(_code_editor->get_text(),
						ChioTerm::MultiLineChioTerm)) ;
					_code_editor->modified(false) ;
				}
			}
			if (_current_state) _current_state->attach(this) ;
			update_current_state() ;
		}
	}
	else
		XtSetSensitive(_form->widget(), False) ;
}

void StateDialogDirector::
update_current_state()
{
	if (_current_state)
	{
		XmTextFieldSetString(_name_entry,
			(char *)_current_state->name().internal_to_external().
			c_str()) ;
		_param_dialog->state(_current_state) ;
		_trans_dialog->state(_current_state) ;
		if (_code_editor->modified())
		{
			_current_state->code(ChioTerm(_code_editor->get_text(),
				ChioTerm::MultiLineChioTerm)) ;
			_code_editor->modified(false) ;
		}
		_code_editor->set_text(_current_state->code().c_str()) ;
		XtSetSensitive(_form->widget(), True) ;
	}
	else
	{
		XmTextFieldSetString(_name_entry, "") ;
		_param_dialog->state(NULL) ;
		_trans_dialog->state(NULL) ;
		_code_editor->set_text("") ;
		XtSetSensitive(_form->widget(), False) ;
	}
}

void StateDialogDirector::
edit_state_code()
{
	_code_editor->manage() ;
}

void StateDialogDirector::
set_state_code()
{
	if (_current_state)
		_current_state->code(ChioTerm(_code_editor->get_text(),
			ChioTerm::MultiLineChioTerm)) ;
}

void StateDialogDirector::
set_state_name()
{
	if (_current_state)
	{
		char *name_string = XmTextFieldGetString(_name_entry) ;
		ChioTerm new_name(name_string, ChioTerm::StringChioTerm,
			ChioTerm::ExternalChioTerm) ;
		XtFree(name_string) ;
		_current_state->rename(new_name) ;
		XmTextFieldSetString(_name_entry,
			(char *)_current_state->name().internal_to_external().c_str()) ;
	}
}

void StateDialogDirector::
name_entry_cb(
	Widget widget,
	XtPointer closure,
	XtPointer callback_data)
{
	StateDialogDirector *dd = (StateDialogDirector *)closure ;
	dd->set_state_name() ;
	XmProcessTraversal(widget, XmTRAVERSE_NEXT_TAB_GROUP) ;
}
