/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: StateDialogDirector.h,v $
$Revision: 1.4 $
$Date: 1997/07/02 04:45:11 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: StateDialogDirector.h,v $
Revision 1.4  1997/07/02 04:45:11  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.3  1997/06/06 04:34:27  andrewm
Checkpoint.  Changed the Subject / Observer code to include a
pointer to the changed subject in the call to "update".  This allowed
a given observer to observe muliple subjects.  Then I modified
various dialogs, especially those in that control the various fields
in the state machine to observe multiple subjects as necessary to
insure that all their fields were updated properly.

Revision 1.2  1997/04/24 03:20:46  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.1  1997/04/16 04:06:15  andrewm
Checkpoint, as last major dialog is in.

 *--
 */
#ifndef _StateDialogDirector_h_
#define _StateDialogDirector_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "DialogDirector.h"
#include "Observer.h"

#include <X11/Intrinsic.h>

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/
class GsmDocument ;
class State ;
class DialogForm ;
class StateParameterDialog ;
class UnspecTransitionDialog ;
class MenuButton ;
class TextEditor ;
class UIComponent ;
class DocPageState ;

/*
CLASS DEFINITIONS
*/
class StateDialogDirector :
	public DialogDirector,
	public Observer
{
public:
	StateDialogDirector(const char *name, UIComponent *parent,
		GsmDocument& document) ;
	~StateDialogDirector() ;
	
	virtual void show_dialog() ;
	virtual void dismiss_dialog() ;

	virtual void update(const Subject *subject) ;
	virtual void subject_deleted(Subject *subject) ;

private:
	GsmDocument& _doc ;
	DocPageState *_page_state ;
	State *_current_state ;
	DialogForm *_form ;
	Widget _name_entry ;
	StateParameterDialog *_param_dialog ;
	UnspecTransitionDialog *_trans_dialog ;
	MenuButton *_code_button ;
	TextEditor *_code_editor ;

private:
	void update_doc() ;
	void update_page_state() ;
	void update_current_state() ;
	void edit_state_code() ;
	void set_state_code() ;
	void set_state_name() ;

private:
	static void name_entry_cb(Widget widget, XtPointer closure,
		XtPointer callback_data) ;
} ;


#endif /* _StateDialogDirector_h_ */
