/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MachEvent.h,v $
$Revision: 1.12 $
$Date: 1997/07/02 04:45:12 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MachEvent.h,v $
Revision 1.12  1997/07/02 04:45:12  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.11  1997/05/31 21:12:42  andrewm
Checkpoint.  Things are working well.

Revision 1.10  1997/05/15 04:14:44  andrewm
Checkpoint.  Reworked the low level file format stuff to contain
proper lists rather than maps keyed to binary numbers.
This point represents the entire program working with this file format
change.

Revision 1.9  1997/04/24 03:20:47  andrewm
Checkpoint.  All features in.  Starting test cycle.

Revision 1.8  1997/03/04 06:32:54  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.7  1996/12/26 05:55:24  andrewm
Checkpoint, the compiler is working again.

Revision 1.6  1996/12/24 05:20:10  andrewm
Checkpoint.

Revision 1.5  1996/09/22 01:18:22  andrewm
pre-alpha release

 * Revision 1.4  1996/08/18  17:57:45  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/15  01:20:40  andrewm
 * checkpoint again
 *
 * Revision 1.2  1996/06/26  03:14:43  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/06/15  23:53:13  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _MachEvent_h_
#define _MachEvent_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include <string>
#include <list>
#include "Chio.h"
#include "Observer.h"
#include "MachineVisitor.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS FORWARD REFERENCES
*/

class Smachine ;
class EventParameter ;

/*
CLASS DEFINITIONS
*/

class MachEvent :
	public Subject
{
	friend ostream& operator <<(ostream& stream, MachEvent& event) ;

public:
	typedef list<EventParameter *> ParameterList ;
	typedef list<EventParameter *>::iterator ParameterListIter ;
	typedef list<EventParameter *>::const_iterator ParameterListConstIter ;

public:
	MachEvent(Smachine *parent, const ChioTerm& name) ;
	MachEvent(Smachine *parent, ChioMapIter place) ;
	~MachEvent() ;

	bool modified() const ;
	void modified(bool new_modified) ;
	void sync() ;
	const ChioTerm& name() const { return _name ; }
	void rename(const ChioTerm& new_name) ;
	Smachine *parent() const { return _parent ; }
	void orphan() { _parent = NULL ; }

	EventParameter *find_parameter(
		const ChioTerm& type,
		const ChioTerm& name) const ;
	EventParameter *add_parameter(const ChioTerm& type, const ChioTerm& name) ;
	EventParameter *insert_parameter(EventParameter *current,
		const ChioTerm& type, const ChioTerm& name) ;
	bool change_parameter(EventParameter *parameter,
		const ChioTerm& type, const ChioTerm& name) ;
	void remove_parameter(EventParameter *parameter) ;
	ParameterList& parameter_list() { return _param_list ; }
	ChioList& parameters() ;

	void accept_visitor(MachineVisitor& visitor) { visitor.visit(this) ; }

private:
	Smachine *_parent ;
	ChioTerm _name ;
	bool _modified ;
	ParameterList _param_list ;

private:
	ChioMapIter find_place() ;
	MachEvent& operator=(const MachEvent& event) ;	// no assigments
} ;


#endif /* _MachEvent_h_ */
